@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetSecurityUserConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationName The name of the network manager Security Configuration.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetSecurityUserConfigurationPlainArgs(
    public val configurationName: String,
    public val networkManagerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetSecurityUserConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetSecurityUserConfigurationPlainArgs = com.pulumi.azurenative.network.inputs.GetSecurityUserConfigurationPlainArgs.builder()
        .configurationName(configurationName.let({ args0 -> args0 }))
        .networkManagerName(networkManagerName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityUserConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityUserConfigurationPlainArgsBuilder internal constructor() {
    private var configurationName: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("ybkfasycbssutbjo")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("kbndmncihpfwimys")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hffalgbwcgekbasb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetSecurityUserConfigurationPlainArgs =
        GetSecurityUserConfigurationPlainArgs(
            configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
            networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
