@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property resourceGroupName The name of the resource group.
 * @property serviceEndpointPolicyName The name of the service endpoint policy.
 */
public data class GetServiceEndpointPolicyPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val serviceEndpointPolicyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyPlainArgs =
        com.pulumi.azurenative.network.inputs.GetServiceEndpointPolicyPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceEndpointPolicyName(serviceEndpointPolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceEndpointPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetServiceEndpointPolicyPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var serviceEndpointPolicyName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("pyjtkynpbarlynly")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vfciegumydqoxwya")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service endpoint policy.
     */
    @JvmName("khepadaedycsbvpg")
    public suspend fun serviceEndpointPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceEndpointPolicyName = mapped
    }

    internal fun build(): GetServiceEndpointPolicyPlainArgs = GetServiceEndpointPolicyPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceEndpointPolicyName = serviceEndpointPolicyName ?: throw
            PulumiNullFieldException("serviceEndpointPolicyName"),
    )
}
