@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayBgpPeerStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peer The IP address of the peer to retrieve the status of.
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkGatewayName The name of the virtual network gateway.
 */
public data class GetVirtualNetworkGatewayBgpPeerStatusPlainArgs(
    public val peer: String? = null,
    public val resourceGroupName: String,
    public val virtualNetworkGatewayName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayBgpPeerStatusPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayBgpPeerStatusPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayBgpPeerStatusPlainArgs.builder()
            .peer(peer?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayBgpPeerStatusPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayBgpPeerStatusPlainArgsBuilder internal constructor() {
    private var peer: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayName: String? = null

    /**
     * @param value The IP address of the peer to retrieve the status of.
     */
    @JvmName("mqimavmekktckaer")
    public suspend fun peer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.peer = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("agbkmveulxecrmsc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network gateway.
     */
    @JvmName("vebvpmujxsxghgqx")
    public suspend fun virtualNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayBgpPeerStatusPlainArgs =
        GetVirtualNetworkGatewayBgpPeerStatusPlainArgs(
            peer = peer,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkGatewayName = virtualNetworkGatewayName ?: throw
                PulumiNullFieldException("virtualNetworkGatewayName"),
        )
}
