@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkGatewayName The virtual network gateway name.
 */
public data class GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkGatewayName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gkrtwudmbjrughmu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The virtual network gateway name.
     */
    @JvmName("whxjunabynneyruo")
    public suspend fun virtualNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs =
        GetVirtualNetworkGatewayVpnclientIpsecParametersPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkGatewayName = virtualNetworkGatewayName ?: throw
                PulumiNullFieldException("virtualNetworkGatewayName"),
        )
}
