@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVpnServerConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the VpnServerConfiguration.
 * @property vpnServerConfigurationName The name of the VpnServerConfiguration being retrieved.
 */
public data class GetVpnServerConfigurationPlainArgs(
    public val resourceGroupName: String,
    public val vpnServerConfigurationName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVpnServerConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVpnServerConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVpnServerConfigurationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vpnServerConfigurationName(vpnServerConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpnServerConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetVpnServerConfigurationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vpnServerConfigurationName: String? = null

    /**
     * @param value The resource group name of the VpnServerConfiguration.
     */
    @JvmName("nwjchbdfnqnsjpto")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration being retrieved.
     */
    @JvmName("mteobvaixmksoodb")
    public suspend fun vpnServerConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpnServerConfigurationName = mapped
    }

    internal fun build(): GetVpnServerConfigurationPlainArgs = GetVpnServerConfigurationPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vpnServerConfigurationName = vpnServerConfigurationName ?: throw
            PulumiNullFieldException("vpnServerConfigurationName"),
    )
}
