@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVpnSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the VpnSite.
 * @property vpnSiteName The name of the VpnSite being retrieved.
 */
public data class GetVpnSitePlainArgs(
    public val resourceGroupName: String,
    public val vpnSiteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVpnSitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVpnSitePlainArgs =
        com.pulumi.azurenative.network.inputs.GetVpnSitePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vpnSiteName(vpnSiteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpnSitePlainArgs].
 */
@PulumiTagMarker
public class GetVpnSitePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vpnSiteName: String? = null

    /**
     * @param value The resource group name of the VpnSite.
     */
    @JvmName("kjisdlfsuodngxph")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VpnSite being retrieved.
     */
    @JvmName("jnwlkgdcjcjlubnv")
    public suspend fun vpnSiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpnSiteName = mapped
    }

    internal fun build(): GetVpnSitePlainArgs = GetVpnSitePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vpnSiteName = vpnSiteName ?: throw PulumiNullFieldException("vpnSiteName"),
    )
}
