@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GroupByVariableArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayFirewallUserSessionVariable
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Define user session group by clause variables.
 * @property variableName User Session clause variable.
 */
public data class GroupByVariableArgs(
    public val variableName: Output<Either<String, ApplicationGatewayFirewallUserSessionVariable>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GroupByVariableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GroupByVariableArgs =
        com.pulumi.azurenative.network.inputs.GroupByVariableArgs.builder()
            .variableName(
                variableName.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GroupByVariableArgs].
 */
@PulumiTagMarker
public class GroupByVariableArgsBuilder internal constructor() {
    private var variableName: Output<Either<String, ApplicationGatewayFirewallUserSessionVariable>>? =
        null

    /**
     * @param value User Session clause variable.
     */
    @JvmName("svsnsonbqflktuij")
    public suspend fun variableName(`value`: Output<Either<String, ApplicationGatewayFirewallUserSessionVariable>>) {
        this.variableName = value
    }

    /**
     * @param value User Session clause variable.
     */
    @JvmName("hlpvdubdvmxjmcld")
    public suspend fun variableName(`value`: Either<String, ApplicationGatewayFirewallUserSessionVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    /**
     * @param value User Session clause variable.
     */
    @JvmName("nokdkqtpohlhpdrk")
    public fun variableName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayFirewallUserSessionVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    /**
     * @param value User Session clause variable.
     */
    @JvmName("nfyssrpdxbhejniy")
    public fun variableName(`value`: ApplicationGatewayFirewallUserSessionVariable) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayFirewallUserSessionVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    internal fun build(): GroupByVariableArgs = GroupByVariableArgs(
        variableName = variableName ?: throw PulumiNullFieldException("variableName"),
    )
}
