@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HTTPHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The HTTP header.
 * @property name The name in HTTP header.
 * @property value The value in HTTP header.
 */
public data class HTTPHeaderArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HTTPHeaderArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HTTPHeaderArgs =
        com.pulumi.azurenative.network.inputs.HTTPHeaderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HTTPHeaderArgs].
 */
@PulumiTagMarker
public class HTTPHeaderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name in HTTP header.
     */
    @JvmName("axjyhuineyimrsiv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value in HTTP header.
     */
    @JvmName("ahgcxarvxufwevsd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name in HTTP header.
     */
    @JvmName("jrieuixyshvohend")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value in HTTP header.
     */
    @JvmName("wujspjkxxwoetufq")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HTTPHeaderArgs = HTTPHeaderArgs(
        name = name,
        `value` = `value`,
    )
}
