@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HealthProbeSettingsModelArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorHealthProbeMethod
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorProtocol
import com.pulumi.azurenative.network.kotlin.enums.HealthProbeEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Load balancing settings for a backend pool
 * @property enabledState Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
 * @property healthProbeMethod Configures which HTTP method to use to probe the backends defined under backendPools.
 * @property id Resource ID.
 * @property intervalInSeconds The number of seconds between health probes.
 * @property name Resource name.
 * @property path The path to use for the health probe. Default is /
 * @property protocol Protocol scheme to use for this probe
 */
public data class HealthProbeSettingsModelArgs(
    public val enabledState: Output<Either<String, HealthProbeEnabled>>? = null,
    public val healthProbeMethod: Output<Either<String, FrontDoorHealthProbeMethod>>? = null,
    public val id: Output<String>? = null,
    public val intervalInSeconds: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
    public val protocol: Output<Either<String, FrontDoorProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HealthProbeSettingsModelArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HealthProbeSettingsModelArgs =
        com.pulumi.azurenative.network.inputs.HealthProbeSettingsModelArgs.builder()
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .healthProbeMethod(
                healthProbeMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [HealthProbeSettingsModelArgs].
 */
@PulumiTagMarker
public class HealthProbeSettingsModelArgsBuilder internal constructor() {
    private var enabledState: Output<Either<String, HealthProbeEnabled>>? = null

    private var healthProbeMethod: Output<Either<String, FrontDoorHealthProbeMethod>>? = null

    private var id: Output<String>? = null

    private var intervalInSeconds: Output<Int>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    private var protocol: Output<Either<String, FrontDoorProtocol>>? = null

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("cuokgnndwnxaatpt")
    public suspend fun enabledState(`value`: Output<Either<String, HealthProbeEnabled>>) {
        this.enabledState = value
    }

    /**
     * @param value Configures which HTTP method to use to probe the backends defined under backendPools.
     */
    @JvmName("hihvuqikpduowjow")
    public suspend fun healthProbeMethod(`value`: Output<Either<String, FrontDoorHealthProbeMethod>>) {
        this.healthProbeMethod = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ykwmexalrkjvpkcp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The number of seconds between health probes.
     */
    @JvmName("tobdrnfbprrecrns")
    public suspend fun intervalInSeconds(`value`: Output<Int>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("weiilopvlohsqfpu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The path to use for the health probe. Default is /
     */
    @JvmName("sacypkqemsidgfmh")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Protocol scheme to use for this probe
     */
    @JvmName("wgeaqykcjhxprykw")
    public suspend fun protocol(`value`: Output<Either<String, FrontDoorProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("eupbfpyeoomrbtgr")
    public suspend fun enabledState(`value`: Either<String, HealthProbeEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("lsxahjhkjmjbhpsj")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HealthProbeEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
     */
    @JvmName("qlcjiittxmnqngsx")
    public fun enabledState(`value`: HealthProbeEnabled) {
        val toBeMapped = Either.ofRight<String, HealthProbeEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Configures which HTTP method to use to probe the backends defined under backendPools.
     */
    @JvmName("rkqsdectpfhhqnog")
    public suspend fun healthProbeMethod(`value`: Either<String, FrontDoorHealthProbeMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeMethod = mapped
    }

    /**
     * @param value Configures which HTTP method to use to probe the backends defined under backendPools.
     */
    @JvmName("shgewqlweyuwpvco")
    public fun healthProbeMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorHealthProbeMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthProbeMethod = mapped
    }

    /**
     * @param value Configures which HTTP method to use to probe the backends defined under backendPools.
     */
    @JvmName("loqkdttxrmrramgp")
    public fun healthProbeMethod(`value`: FrontDoorHealthProbeMethod) {
        val toBeMapped = Either.ofRight<String, FrontDoorHealthProbeMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthProbeMethod = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qshmjnoaufbeoemf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The number of seconds between health probes.
     */
    @JvmName("moqthisvnbdqknov")
    public suspend fun intervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("akmynnqoegmtgtnw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The path to use for the health probe. Default is /
     */
    @JvmName("uutvttmcthxvhbnl")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Protocol scheme to use for this probe
     */
    @JvmName("rwxuohmaxjqlelqm")
    public suspend fun protocol(`value`: Either<String, FrontDoorProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol scheme to use for this probe
     */
    @JvmName("atqyckamvqreacvk")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol scheme to use for this probe
     */
    @JvmName("yvahrumutcjucync")
    public fun protocol(`value`: FrontDoorProtocol) {
        val toBeMapped = Either.ofRight<String, FrontDoorProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): HealthProbeSettingsModelArgs = HealthProbeSettingsModelArgs(
        enabledState = enabledState,
        healthProbeMethod = healthProbeMethod,
        id = id,
        intervalInSeconds = intervalInSeconds,
        name = name,
        path = path,
        protocol = protocol,
    )
}
