@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.TransportProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Inbound NAT rule of the load balancer.
 * @property backendAddressPool A reference to backendAddressPool resource.
 * @property backendPort The port used for the internal endpoint. Acceptable values range from 1 to 65535.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
 * @property frontendPortRangeEnd The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
 * @property frontendPortRangeStart The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property name The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 */
public data class InboundNatRuleArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val backendPort: Output<Int>? = null,
    public val enableFloatingIP: Output<Boolean>? = null,
    public val enableTcpReset: Output<Boolean>? = null,
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPort: Output<Int>? = null,
    public val frontendPortRangeEnd: Output<Int>? = null,
    public val frontendPortRangeStart: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, TransportProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.InboundNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.InboundNatRuleArgs =
        com.pulumi.azurenative.network.inputs.InboundNatRuleArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .enableFloatingIP(enableFloatingIP?.applyValue({ args0 -> args0 }))
            .enableTcpReset(enableTcpReset?.applyValue({ args0 -> args0 }))
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPort(frontendPort?.applyValue({ args0 -> args0 }))
            .frontendPortRangeEnd(frontendPortRangeEnd?.applyValue({ args0 -> args0 }))
            .frontendPortRangeStart(frontendPortRangeStart?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [InboundNatRuleArgs].
 */
@PulumiTagMarker
public class InboundNatRuleArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var backendPort: Output<Int>? = null

    private var enableFloatingIP: Output<Boolean>? = null

    private var enableTcpReset: Output<Boolean>? = null

    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPort: Output<Int>? = null

    private var frontendPortRangeEnd: Output<Int>? = null

    private var frontendPortRangeStart: Output<Int>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, TransportProtocol>>? = null

    /**
     * @param value A reference to backendAddressPool resource.
     */
    @JvmName("rfbcilitdbterkdy")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     */
    @JvmName("mmllgymhbouinmsp")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("dwijrdhsmsikyits")
    public suspend fun enableFloatingIP(`value`: Output<Boolean>) {
        this.enableFloatingIP = value
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("nrebdblowfkuhism")
    public suspend fun enableTcpReset(`value`: Output<Boolean>) {
        this.enableTcpReset = value
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("tbvisdlugelwntwe")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
     */
    @JvmName("rqvsggqmmhiqidrd")
    public suspend fun frontendPort(`value`: Output<Int>) {
        this.frontendPort = value
    }

    /**
     * @param value The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("dgxsmmacouvafqgy")
    public suspend fun frontendPortRangeEnd(`value`: Output<Int>) {
        this.frontendPortRangeEnd = value
    }

    /**
     * @param value The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("wurkbcibpwwjakmt")
    public suspend fun frontendPortRangeStart(`value`: Output<Int>) {
        this.frontendPortRangeStart = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ggpeimemomvjfmvq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("axtfstcrxrrrysrp")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("briejfcwpbwnppof")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("jbsdwlteokdbtven")
    public suspend fun protocol(`value`: Output<Either<String, TransportProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value A reference to backendAddressPool resource.
     */
    @JvmName("rcsjiuyncpdgkxyo")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument A reference to backendAddressPool resource.
     */
    @JvmName("hivpuxrfpkbrrhko")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     */
    @JvmName("uvkeaoskcgvjdepp")
    public suspend fun backendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("timotbdujbdagqds")
    public suspend fun enableFloatingIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFloatingIP = mapped
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("fubojwoevmengjnp")
    public suspend fun enableTcpReset(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTcpReset = mapped
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("klvcnohejtxqhcva")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument A reference to frontend IP addresses.
     */
    @JvmName("jlxxitpuwiqqbxsd")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
     */
    @JvmName("uvlvuexjkdsehbgb")
    public suspend fun frontendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("nxduoqpwpolvhyjs")
    public suspend fun frontendPortRangeEnd(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPortRangeEnd = mapped
    }

    /**
     * @param value The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     */
    @JvmName("nksfiltjdxbnfnfd")
    public suspend fun frontendPortRangeStart(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPortRangeStart = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qachxgptthigckrw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("fowwhpgommcveaxb")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("umexkqvwfsoktlhn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("jrgtuebmhegkbesx")
    public suspend fun protocol(`value`: Either<String, TransportProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("jpeliruvgkxkhuty")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the load balancing rule.
     */
    @JvmName("pwfscdeqycpmbvkj")
    public fun protocol(`value`: TransportProtocol) {
        val toBeMapped = Either.ofRight<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): InboundNatRuleArgs = InboundNatRuleArgs(
        backendAddressPool = backendAddressPool,
        backendPort = backendPort,
        enableFloatingIP = enableFloatingIP,
        enableTcpReset = enableTcpReset,
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPort = frontendPort,
        frontendPortRangeEnd = frontendPortRangeEnd,
        frontendPortRangeStart = frontendPortRangeStart,
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        name = name,
        protocol = protocol,
    )
}
