@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.Ipv6ExpressRouteCircuitPeeringConfigArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRouteCircuitPeeringState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contains IPv6 peering config.
 * @property microsoftPeeringConfig The Microsoft peering configuration.
 * @property primaryPeerAddressPrefix The primary address prefix.
 * @property routeFilter The reference to the RouteFilter resource.
 * @property secondaryPeerAddressPrefix The secondary address prefix.
 * @property state The state of peering.
 */
public data class Ipv6ExpressRouteCircuitPeeringConfigArgs(
    public val microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigArgs>? = null,
    public val primaryPeerAddressPrefix: Output<String>? = null,
    public val routeFilter: Output<SubResourceArgs>? = null,
    public val secondaryPeerAddressPrefix: Output<String>? = null,
    public val state: Output<Either<String, ExpressRouteCircuitPeeringState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.Ipv6ExpressRouteCircuitPeeringConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.Ipv6ExpressRouteCircuitPeeringConfigArgs =
        com.pulumi.azurenative.network.inputs.Ipv6ExpressRouteCircuitPeeringConfigArgs.builder()
            .microsoftPeeringConfig(
                microsoftPeeringConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .primaryPeerAddressPrefix(primaryPeerAddressPrefix?.applyValue({ args0 -> args0 }))
            .routeFilter(routeFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secondaryPeerAddressPrefix(secondaryPeerAddressPrefix?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [Ipv6ExpressRouteCircuitPeeringConfigArgs].
 */
@PulumiTagMarker
public class Ipv6ExpressRouteCircuitPeeringConfigArgsBuilder internal constructor() {
    private var microsoftPeeringConfig: Output<ExpressRouteCircuitPeeringConfigArgs>? = null

    private var primaryPeerAddressPrefix: Output<String>? = null

    private var routeFilter: Output<SubResourceArgs>? = null

    private var secondaryPeerAddressPrefix: Output<String>? = null

    private var state: Output<Either<String, ExpressRouteCircuitPeeringState>>? = null

    /**
     * @param value The Microsoft peering configuration.
     */
    @JvmName("bciihdgaaigfdhkv")
    public suspend fun microsoftPeeringConfig(`value`: Output<ExpressRouteCircuitPeeringConfigArgs>) {
        this.microsoftPeeringConfig = value
    }

    /**
     * @param value The primary address prefix.
     */
    @JvmName("edxxvcppxdhxgosc")
    public suspend fun primaryPeerAddressPrefix(`value`: Output<String>) {
        this.primaryPeerAddressPrefix = value
    }

    /**
     * @param value The reference to the RouteFilter resource.
     */
    @JvmName("eqxdmdnfogjjawun")
    public suspend fun routeFilter(`value`: Output<SubResourceArgs>) {
        this.routeFilter = value
    }

    /**
     * @param value The secondary address prefix.
     */
    @JvmName("oqbvmduvqsbbpays")
    public suspend fun secondaryPeerAddressPrefix(`value`: Output<String>) {
        this.secondaryPeerAddressPrefix = value
    }

    /**
     * @param value The state of peering.
     */
    @JvmName("csnwuhvlnogwpxlp")
    public suspend fun state(`value`: Output<Either<String, ExpressRouteCircuitPeeringState>>) {
        this.state = value
    }

    /**
     * @param value The Microsoft peering configuration.
     */
    @JvmName("uurpdcsmxkoisecb")
    public suspend fun microsoftPeeringConfig(`value`: ExpressRouteCircuitPeeringConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftPeeringConfig = mapped
    }

    /**
     * @param argument The Microsoft peering configuration.
     */
    @JvmName("qopppeggpjfpmsyk")
    public suspend fun microsoftPeeringConfig(argument: suspend ExpressRouteCircuitPeeringConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitPeeringConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.microsoftPeeringConfig = mapped
    }

    /**
     * @param value The primary address prefix.
     */
    @JvmName("mlsacaftqfwdrwdx")
    public suspend fun primaryPeerAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryPeerAddressPrefix = mapped
    }

    /**
     * @param value The reference to the RouteFilter resource.
     */
    @JvmName("xkltfwetloeleial")
    public suspend fun routeFilter(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilter = mapped
    }

    /**
     * @param argument The reference to the RouteFilter resource.
     */
    @JvmName("mgqsllwiawolfxbj")
    public suspend fun routeFilter(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeFilter = mapped
    }

    /**
     * @param value The secondary address prefix.
     */
    @JvmName("kaewpspvaxtyeqor")
    public suspend fun secondaryPeerAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPeerAddressPrefix = mapped
    }

    /**
     * @param value The state of peering.
     */
    @JvmName("pcxhiobpnmgsllpi")
    public suspend fun state(`value`: Either<String, ExpressRouteCircuitPeeringState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of peering.
     */
    @JvmName("xgbtbhtbnvvppvsf")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRouteCircuitPeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of peering.
     */
    @JvmName("nieevxidyltwdfew")
    public fun state(`value`: ExpressRouteCircuitPeeringState) {
        val toBeMapped = Either.ofRight<String, ExpressRouteCircuitPeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): Ipv6ExpressRouteCircuitPeeringConfigArgs =
        Ipv6ExpressRouteCircuitPeeringConfigArgs(
            microsoftPeeringConfig = microsoftPeeringConfig,
            primaryPeerAddressPrefix = primaryPeerAddressPrefix,
            routeFilter = routeFilter,
            secondaryPeerAddressPrefix = secondaryPeerAddressPrefix,
            state = state,
        )
}
