@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.LoadBalancerSkuName
import com.pulumi.azurenative.network.kotlin.enums.LoadBalancerSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of a load balancer.
 * @property name Name of a load balancer SKU.
 * @property tier Tier of a load balancer SKU.
 */
public data class LoadBalancerSkuArgs(
    public val name: Output<Either<String, LoadBalancerSkuName>>? = null,
    public val tier: Output<Either<String, LoadBalancerSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs =
        com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerSkuArgs].
 */
@PulumiTagMarker
public class LoadBalancerSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, LoadBalancerSkuName>>? = null

    private var tier: Output<Either<String, LoadBalancerSkuTier>>? = null

    /**
     * @param value Name of a load balancer SKU.
     */
    @JvmName("pdogqrjbmtehhjrv")
    public suspend fun name(`value`: Output<Either<String, LoadBalancerSkuName>>) {
        this.name = value
    }

    /**
     * @param value Tier of a load balancer SKU.
     */
    @JvmName("vmcmrivfwpqjiump")
    public suspend fun tier(`value`: Output<Either<String, LoadBalancerSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Name of a load balancer SKU.
     */
    @JvmName("bxgibbmyumrrfouw")
    public suspend fun name(`value`: Either<String, LoadBalancerSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of a load balancer SKU.
     */
    @JvmName("dykjcggmoorrbegj")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of a load balancer SKU.
     */
    @JvmName("witkwfosciidnmie")
    public fun name(`value`: LoadBalancerSkuName) {
        val toBeMapped = Either.ofRight<String, LoadBalancerSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of a load balancer SKU.
     */
    @JvmName("osmpxbssudfkglpy")
    public suspend fun tier(`value`: Either<String, LoadBalancerSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of a load balancer SKU.
     */
    @JvmName("klkqcngkeveovnhw")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of a load balancer SKU.
     */
    @JvmName("ushctrrslxjpbhci")
    public fun tier(`value`: LoadBalancerSkuTier) {
        val toBeMapped = Either.ofRight<String, LoadBalancerSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): LoadBalancerSkuArgs = LoadBalancerSkuArgs(
        name = name,
        tier = tier,
    )
}
