@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.LocalNetworkGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A common class for general resource information.
 * @property bgpSettings Local network gateway's BGP speaker settings.
 * @property fqdn FQDN of local network gateway.
 * @property gatewayIpAddress IP address of local network gateway.
 * @property id Resource ID.
 * @property localNetworkAddressSpace Local network site address space.
 * @property location Resource location.
 * @property tags Resource tags.
 */
public data class LocalNetworkGatewayArgs(
    public val bgpSettings: Output<BgpSettingsArgs>? = null,
    public val fqdn: Output<String>? = null,
    public val gatewayIpAddress: Output<String>? = null,
    public val id: Output<String>? = null,
    public val localNetworkAddressSpace: Output<AddressSpaceArgs>? = null,
    public val location: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.LocalNetworkGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.LocalNetworkGatewayArgs =
        com.pulumi.azurenative.network.inputs.LocalNetworkGatewayArgs.builder()
            .bgpSettings(bgpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .gatewayIpAddress(gatewayIpAddress?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .localNetworkAddressSpace(
                localNetworkAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocalNetworkGatewayArgs].
 */
@PulumiTagMarker
public class LocalNetworkGatewayArgsBuilder internal constructor() {
    private var bgpSettings: Output<BgpSettingsArgs>? = null

    private var fqdn: Output<String>? = null

    private var gatewayIpAddress: Output<String>? = null

    private var id: Output<String>? = null

    private var localNetworkAddressSpace: Output<AddressSpaceArgs>? = null

    private var location: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Local network gateway's BGP speaker settings.
     */
    @JvmName("igxoyeygqpuwjooi")
    public suspend fun bgpSettings(`value`: Output<BgpSettingsArgs>) {
        this.bgpSettings = value
    }

    /**
     * @param value FQDN of local network gateway.
     */
    @JvmName("xmwibysvatyasitl")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value IP address of local network gateway.
     */
    @JvmName("hbhfuvcbhycadrwa")
    public suspend fun gatewayIpAddress(`value`: Output<String>) {
        this.gatewayIpAddress = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ovlnmcnncdjgtxcr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Local network site address space.
     */
    @JvmName("pajinyhodscgnxuq")
    public suspend fun localNetworkAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.localNetworkAddressSpace = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("nictopfkxhfjjuyb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qljarhymldvyfemj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Local network gateway's BGP speaker settings.
     */
    @JvmName("cjaxfjwoywgeakjs")
    public suspend fun bgpSettings(`value`: BgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSettings = mapped
    }

    /**
     * @param argument Local network gateway's BGP speaker settings.
     */
    @JvmName("pqlfqbwoxqrvpgan")
    public suspend fun bgpSettings(argument: suspend BgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSettings = mapped
    }

    /**
     * @param value FQDN of local network gateway.
     */
    @JvmName("ufubdtsnofbxwhnw")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value IP address of local network gateway.
     */
    @JvmName("tgssdjyrqjvbuvdo")
    public suspend fun gatewayIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayIpAddress = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xmlqldjkmnwuvcel")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Local network site address space.
     */
    @JvmName("jvcstqsyxpqgmhdn")
    public suspend fun localNetworkAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localNetworkAddressSpace = mapped
    }

    /**
     * @param argument Local network site address space.
     */
    @JvmName("dvsragrwqmtkxqto")
    public suspend fun localNetworkAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localNetworkAddressSpace = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jkgfefnfstjpyyar")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogawalrxbeprtwyh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rgchqqopgsckwfed")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocalNetworkGatewayArgs = LocalNetworkGatewayArgs(
        bgpSettings = bgpSettings,
        fqdn = fqdn,
        gatewayIpAddress = gatewayIpAddress,
        id = id,
        localNetworkAddressSpace = localNetworkAddressSpace,
        location = location,
        tags = tags,
    )
}
