@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ManagedRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule set.
 * @property ruleGroupOverrides Defines the rule group overrides to apply to the rule set.
 * @property ruleSetType Defines the rule set type to use.
 * @property ruleSetVersion Defines the version of the rule set to use.
 */
public data class ManagedRuleSetArgs(
    public val ruleGroupOverrides: Output<List<ManagedRuleGroupOverrideArgs>>? = null,
    public val ruleSetType: Output<String>,
    public val ruleSetVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ManagedRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ManagedRuleSetArgs =
        com.pulumi.azurenative.network.inputs.ManagedRuleSetArgs.builder()
            .ruleGroupOverrides(
                ruleGroupOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleSetType(ruleSetType.applyValue({ args0 -> args0 }))
            .ruleSetVersion(ruleSetVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedRuleSetArgs].
 */
@PulumiTagMarker
public class ManagedRuleSetArgsBuilder internal constructor() {
    private var ruleGroupOverrides: Output<List<ManagedRuleGroupOverrideArgs>>? = null

    private var ruleSetType: Output<String>? = null

    private var ruleSetVersion: Output<String>? = null

    /**
     * @param value Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("rolhbthmhdojcfnq")
    public suspend fun ruleGroupOverrides(`value`: Output<List<ManagedRuleGroupOverrideArgs>>) {
        this.ruleGroupOverrides = value
    }

    @JvmName("uppyxgmgtyuockvl")
    public suspend fun ruleGroupOverrides(vararg values: Output<ManagedRuleGroupOverrideArgs>) {
        this.ruleGroupOverrides = Output.all(values.asList())
    }

    /**
     * @param values Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("aouevucveoafukaj")
    public suspend fun ruleGroupOverrides(values: List<Output<ManagedRuleGroupOverrideArgs>>) {
        this.ruleGroupOverrides = Output.all(values)
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("gtcgueqntnqmqvjn")
    public suspend fun ruleSetType(`value`: Output<String>) {
        this.ruleSetType = value
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("ryrjvdcosevuwkoy")
    public suspend fun ruleSetVersion(`value`: Output<String>) {
        this.ruleSetVersion = value
    }

    /**
     * @param value Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("vkfagkmpqcthnndl")
    public suspend fun ruleGroupOverrides(`value`: List<ManagedRuleGroupOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("qwugnlumtkemcqdj")
    public suspend fun ruleGroupOverrides(argument: List<suspend ManagedRuleGroupOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleGroupOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("ggoebbyxunyrpgwk")
    public suspend fun ruleGroupOverrides(vararg argument: suspend ManagedRuleGroupOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedRuleGroupOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param argument Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("buvlwxajvuwoschs")
    public suspend fun ruleGroupOverrides(argument: suspend ManagedRuleGroupOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedRuleGroupOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param values Defines the rule group overrides to apply to the rule set.
     */
    @JvmName("phmtfdlelpraevpo")
    public suspend fun ruleGroupOverrides(vararg values: ManagedRuleGroupOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupOverrides = mapped
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("bijrlbksmllckbqp")
    public suspend fun ruleSetType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetType = mapped
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("bufgtbprxilidyly")
    public suspend fun ruleSetVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetVersion = mapped
    }

    internal fun build(): ManagedRuleSetArgs = ManagedRuleSetArgs(
        ruleGroupOverrides = ruleGroupOverrides,
        ruleSetType = ruleSetType ?: throw PulumiNullFieldException("ruleSetType"),
        ruleSetVersion = ruleSetVersion ?: throw PulumiNullFieldException("ruleSetVersion"),
    )
}
