@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.MatchVariableArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallMatchVariable
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Define match variables.
 * @property selector The selector of match variable.
 * @property variableName Match Variable.
 */
public data class MatchVariableArgs(
    public val selector: Output<String>? = null,
    public val variableName: Output<Either<String, WebApplicationFirewallMatchVariable>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.MatchVariableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.MatchVariableArgs =
        com.pulumi.azurenative.network.inputs.MatchVariableArgs.builder()
            .selector(selector?.applyValue({ args0 -> args0 }))
            .variableName(
                variableName.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MatchVariableArgs].
 */
@PulumiTagMarker
public class MatchVariableArgsBuilder internal constructor() {
    private var selector: Output<String>? = null

    private var variableName: Output<Either<String, WebApplicationFirewallMatchVariable>>? = null

    /**
     * @param value The selector of match variable.
     */
    @JvmName("wlpwmlpsunonwyjf")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value Match Variable.
     */
    @JvmName("sokkotybqnsqcfuk")
    public suspend fun variableName(`value`: Output<Either<String, WebApplicationFirewallMatchVariable>>) {
        this.variableName = value
    }

    /**
     * @param value The selector of match variable.
     */
    @JvmName("arfpoalddhuhytrm")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value Match Variable.
     */
    @JvmName("dgprpvppakgktlqa")
    public suspend fun variableName(`value`: Either<String, WebApplicationFirewallMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    /**
     * @param value Match Variable.
     */
    @JvmName("slqlvbwugfojktvm")
    public fun variableName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    /**
     * @param value Match Variable.
     */
    @JvmName("dvnykupqurwuatty")
    public fun variableName(`value`: WebApplicationFirewallMatchVariable) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    internal fun build(): MatchVariableArgs = MatchVariableArgs(
        selector = selector,
        variableName = variableName ?: throw PulumiNullFieldException("variableName"),
    )
}
