@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NatGatewaySkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.NatGatewaySkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of nat gateway.
 * @property name Name of Nat Gateway SKU.
 */
public data class NatGatewaySkuArgs(
    public val name: Output<Either<String, NatGatewaySkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NatGatewaySkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NatGatewaySkuArgs =
        com.pulumi.azurenative.network.inputs.NatGatewaySkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NatGatewaySkuArgs].
 */
@PulumiTagMarker
public class NatGatewaySkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, NatGatewaySkuName>>? = null

    /**
     * @param value Name of Nat Gateway SKU.
     */
    @JvmName("hhsxjutnjtkrsrjy")
    public suspend fun name(`value`: Output<Either<String, NatGatewaySkuName>>) {
        this.name = value
    }

    /**
     * @param value Name of Nat Gateway SKU.
     */
    @JvmName("nuovivlpuaqrminu")
    public suspend fun name(`value`: Either<String, NatGatewaySkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of Nat Gateway SKU.
     */
    @JvmName("smihliorjaacayih")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NatGatewaySkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of Nat Gateway SKU.
     */
    @JvmName("vkndtjotdjotwdtl")
    public fun name(`value`: NatGatewaySkuName) {
        val toBeMapped = Either.ofRight<String, NatGatewaySkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): NatGatewaySkuArgs = NatGatewaySkuArgs(
        name = name,
    )
}
