@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyRuleNetworkProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule of type nat.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleNetworkProtocols.
 * @property name Name of the rule.
 * @property ruleType Rule Type.
 * Expected value is 'NatRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property translatedAddress The translated address for this NAT rule.
 * @property translatedFqdn The translated FQDN for this NAT rule.
 * @property translatedPort The translated port for this NAT rule.
 */
public data class NatRuleArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val ipProtocols: Output<List<Either<String, FirewallPolicyRuleNetworkProtocol>>>? = null,
    public val name: Output<String>? = null,
    public val ruleType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
    public val translatedAddress: Output<String>? = null,
    public val translatedFqdn: Output<String>? = null,
    public val translatedPort: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NatRuleArgs =
        com.pulumi.azurenative.network.inputs.NatRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipProtocols(
                ipProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .translatedAddress(translatedAddress?.applyValue({ args0 -> args0 }))
            .translatedFqdn(translatedFqdn?.applyValue({ args0 -> args0 }))
            .translatedPort(translatedPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NatRuleArgs].
 */
@PulumiTagMarker
public class NatRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var ipProtocols: Output<List<Either<String, FirewallPolicyRuleNetworkProtocol>>>? = null

    private var name: Output<String>? = null

    private var ruleType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    private var translatedAddress: Output<String>? = null

    private var translatedFqdn: Output<String>? = null

    private var translatedPort: Output<String>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("mnuhigcuregwublr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("kcgfjhhgilbxdhxh")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("niwxqdcjcfmxgjey")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("knosplmotegikubp")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("lsnhgthynqenjnho")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("yfgbyrwjqnmvndxd")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("sxrbjwbrkflqtygv")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("dfkdssydxtrdrnrt")
    public suspend fun ipProtocols(`value`: Output<List<Either<String, FirewallPolicyRuleNetworkProtocol>>>) {
        this.ipProtocols = value
    }

    @JvmName("iplwkfylwvtimxfu")
    public suspend fun ipProtocols(vararg values: Output<Either<String, FirewallPolicyRuleNetworkProtocol>>) {
        this.ipProtocols = Output.all(values.asList())
    }

    /**
     * @param values Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("gssxvrkqqcjjppai")
    public suspend fun ipProtocols(values: List<Output<Either<String, FirewallPolicyRuleNetworkProtocol>>>) {
        this.ipProtocols = Output.all(values)
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("tukxsqyhhuktnauf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule Type.
     * Expected value is 'NatRule'.
     */
    @JvmName("ximcoddjixrvnrot")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("ucymfkinwhqrutsw")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("hyefkmvknwihvhqa")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("jdgkxhpsovtijeem")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("xtoiifqrhkgxeytj")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("hvrkdmlsmmjrehqh")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("snhnwrjqwmpmdtdi")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value The translated address for this NAT rule.
     */
    @JvmName("bpexahhfplyvtqsv")
    public suspend fun translatedAddress(`value`: Output<String>) {
        this.translatedAddress = value
    }

    /**
     * @param value The translated FQDN for this NAT rule.
     */
    @JvmName("cwcheosnncensnvt")
    public suspend fun translatedFqdn(`value`: Output<String>) {
        this.translatedFqdn = value
    }

    /**
     * @param value The translated port for this NAT rule.
     */
    @JvmName("kukhlufdtqkybphm")
    public suspend fun translatedPort(`value`: Output<String>) {
        this.translatedPort = value
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("vvyhoyjjdetscomh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("aysilbdasohadbtb")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("sgeiiyhyurkdyfud")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("vwnwobndxjufxapg")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("adaufkwrwwpslaib")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("ydlcxijkgywiwwmi")
    public suspend fun ipProtocols(`value`: List<Either<String, FirewallPolicyRuleNetworkProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param values Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("awohjgqajoxomagh")
    public suspend fun ipProtocols(vararg values: Either<String, FirewallPolicyRuleNetworkProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("yabppbdlynpwlxof")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule Type.
     * Expected value is 'NatRule'.
     */
    @JvmName("tvucrauocxfrrfra")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("dqhcmvvcgbcplyqx")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("jrpxfmyxrabfnhdi")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("dulafxbfejwmrfji")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("bimxnheflofjdoox")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param value The translated address for this NAT rule.
     */
    @JvmName("sqtdbuewjrheiuws")
    public suspend fun translatedAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedAddress = mapped
    }

    /**
     * @param value The translated FQDN for this NAT rule.
     */
    @JvmName("jsqskqmgiumjobmc")
    public suspend fun translatedFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedFqdn = mapped
    }

    /**
     * @param value The translated port for this NAT rule.
     */
    @JvmName("pousixqjslbhubll")
    public suspend fun translatedPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedPort = mapped
    }

    internal fun build(): NatRuleArgs = NatRuleArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        destinationPorts = destinationPorts,
        ipProtocols = ipProtocols,
        name = name,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
        translatedAddress = translatedAddress,
        translatedFqdn = translatedFqdn,
        translatedPort = translatedPort,
    )
}
