@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkInterfaceIPConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IPConfiguration in a network interface.
 * @property applicationGatewayBackendAddressPools The reference to ApplicationGatewayBackendAddressPool resource.
 * @property applicationSecurityGroups Application security groups in which the IP configuration is included.
 * @property gatewayLoadBalancer The reference to gateway load balancer frontend IP.
 * @property id Resource ID.
 * @property loadBalancerBackendAddressPools The reference to LoadBalancerBackendAddressPool resource.
 * @property loadBalancerInboundNatRules A list of references of LoadBalancerInboundNatRules.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property primary Whether this is a primary customer address on the network interface.
 * @property privateIPAddress Private IP address of the IP configuration.
 * @property privateIPAddressVersion Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property publicIPAddress Public IP address bound to the IP configuration.
 * @property subnet Subnet bound to the IP configuration.
 * @property type Resource type.
 * @property virtualNetworkTaps The reference to Virtual Network Taps.
 */
public data class NetworkInterfaceIPConfigurationArgs(
    public val applicationGatewayBackendAddressPools: Output<List<ApplicationGatewayBackendAddressPoolArgs>>? = null,
    public val applicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null,
    public val gatewayLoadBalancer: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val loadBalancerBackendAddressPools: Output<List<BackendAddressPoolArgs>>? = null,
    public val loadBalancerInboundNatRules: Output<List<InboundNatRuleArgs>>? = null,
    public val name: Output<String>? = null,
    public val primary: Output<Boolean>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPAddress: Output<PublicIPAddressArgs>? = null,
    public val subnet: Output<SubnetArgs>? = null,
    public val type: Output<String>? = null,
    public val virtualNetworkTaps: Output<List<VirtualNetworkTapArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkInterfaceIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NetworkInterfaceIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.NetworkInterfaceIPConfigurationArgs.builder()
            .applicationGatewayBackendAddressPools(
                applicationGatewayBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .applicationSecurityGroups(
                applicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .gatewayLoadBalancer(
                gatewayLoadBalancer?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .loadBalancerBackendAddressPools(
                loadBalancerBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .loadBalancerInboundNatRules(
                loadBalancerInboundNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAddressVersion(
                privateIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .virtualNetworkTaps(
                virtualNetworkTaps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceIPConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceIPConfigurationArgsBuilder internal constructor() {
    private var applicationGatewayBackendAddressPools:
        Output<List<ApplicationGatewayBackendAddressPoolArgs>>? = null

    private var applicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null

    private var gatewayLoadBalancer: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var loadBalancerBackendAddressPools: Output<List<BackendAddressPoolArgs>>? = null

    private var loadBalancerInboundNatRules: Output<List<InboundNatRuleArgs>>? = null

    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPAddress: Output<PublicIPAddressArgs>? = null

    private var subnet: Output<SubnetArgs>? = null

    private var type: Output<String>? = null

    private var virtualNetworkTaps: Output<List<VirtualNetworkTapArgs>>? = null

    /**
     * @param value The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("idxflhxexkbppryf")
    public suspend fun applicationGatewayBackendAddressPools(`value`: Output<List<ApplicationGatewayBackendAddressPoolArgs>>) {
        this.applicationGatewayBackendAddressPools = value
    }

    @JvmName("xbsldiayyqyspxdi")
    public suspend fun applicationGatewayBackendAddressPools(vararg values: Output<ApplicationGatewayBackendAddressPoolArgs>) {
        this.applicationGatewayBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("tsxertinqflvyuap")
    public suspend fun applicationGatewayBackendAddressPools(values: List<Output<ApplicationGatewayBackendAddressPoolArgs>>) {
        this.applicationGatewayBackendAddressPools = Output.all(values)
    }

    /**
     * @param value Application security groups in which the IP configuration is included.
     */
    @JvmName("avydkrtthbxgqbpr")
    public suspend fun applicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.applicationSecurityGroups = value
    }

    @JvmName("nnbcxtvqyoiwqhii")
    public suspend fun applicationSecurityGroups(vararg values: Output<ApplicationSecurityGroupArgs>) {
        this.applicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values Application security groups in which the IP configuration is included.
     */
    @JvmName("rtdhhqofbrbhdnin")
    public suspend fun applicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.applicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The reference to gateway load balancer frontend IP.
     */
    @JvmName("igjpudokipykgebj")
    public suspend fun gatewayLoadBalancer(`value`: Output<SubResourceArgs>) {
        this.gatewayLoadBalancer = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bnmifprjaxmavnoy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("dhfwkravtfvqrfdn")
    public suspend fun loadBalancerBackendAddressPools(`value`: Output<List<BackendAddressPoolArgs>>) {
        this.loadBalancerBackendAddressPools = value
    }

    @JvmName("qhsptqiexqvktdur")
    public suspend fun loadBalancerBackendAddressPools(vararg values: Output<BackendAddressPoolArgs>) {
        this.loadBalancerBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("wwfdavkhpcoqlkdt")
    public suspend fun loadBalancerBackendAddressPools(values: List<Output<BackendAddressPoolArgs>>) {
        this.loadBalancerBackendAddressPools = Output.all(values)
    }

    /**
     * @param value A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("dgtcvcusuantltqb")
    public suspend fun loadBalancerInboundNatRules(`value`: Output<List<InboundNatRuleArgs>>) {
        this.loadBalancerInboundNatRules = value
    }

    @JvmName("ixjkdkrxnudqhynl")
    public suspend fun loadBalancerInboundNatRules(vararg values: Output<InboundNatRuleArgs>) {
        this.loadBalancerInboundNatRules = Output.all(values.asList())
    }

    /**
     * @param values A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("okhmeolwwsttgbla")
    public suspend fun loadBalancerInboundNatRules(values: List<Output<InboundNatRuleArgs>>) {
        this.loadBalancerInboundNatRules = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("axvdoqhrrktajxns")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether this is a primary customer address on the network interface.
     */
    @JvmName("ccgtchjlajalxokd")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Private IP address of the IP configuration.
     */
    @JvmName("rhmegdtcgnhbkpoc")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("riwmcyfutbddfrfh")
    public suspend fun privateIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.privateIPAddressVersion = value
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("qwtjensughkrombr")
    public suspend fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value Public IP address bound to the IP configuration.
     */
    @JvmName("sxsdcrlvwgbfpkuj")
    public suspend fun publicIPAddress(`value`: Output<PublicIPAddressArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value Subnet bound to the IP configuration.
     */
    @JvmName("qajdqebjnrijxjro")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource type.
     */
    @JvmName("egpxkpwibfqstglf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The reference to Virtual Network Taps.
     */
    @JvmName("mdssmxijhgsjhmbl")
    public suspend fun virtualNetworkTaps(`value`: Output<List<VirtualNetworkTapArgs>>) {
        this.virtualNetworkTaps = value
    }

    @JvmName("hkyiywpsdvaevmnu")
    public suspend fun virtualNetworkTaps(vararg values: Output<VirtualNetworkTapArgs>) {
        this.virtualNetworkTaps = Output.all(values.asList())
    }

    /**
     * @param values The reference to Virtual Network Taps.
     */
    @JvmName("fhnwwmveiynhqrrt")
    public suspend fun virtualNetworkTaps(values: List<Output<VirtualNetworkTapArgs>>) {
        this.virtualNetworkTaps = Output.all(values)
    }

    /**
     * @param value The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("ogxnopirruqajlci")
    public suspend fun applicationGatewayBackendAddressPools(`value`: List<ApplicationGatewayBackendAddressPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("retdoleccaqiafir")
    public suspend fun applicationGatewayBackendAddressPools(argument: List<suspend ApplicationGatewayBackendAddressPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendAddressPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("xmgfsqrotsfxjxfv")
    public suspend fun applicationGatewayBackendAddressPools(vararg argument: suspend ApplicationGatewayBackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendAddressPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("lcsvhpcqscehbwbv")
    public suspend fun applicationGatewayBackendAddressPools(argument: suspend ApplicationGatewayBackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayBackendAddressPoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param values The reference to ApplicationGatewayBackendAddressPool resource.
     */
    @JvmName("oxvtjftqimtsqqyg")
    public suspend fun applicationGatewayBackendAddressPools(vararg values: ApplicationGatewayBackendAddressPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param value Application security groups in which the IP configuration is included.
     */
    @JvmName("cvgefbcissgelfab")
    public suspend fun applicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Application security groups in which the IP configuration is included.
     */
    @JvmName("oitwxehcegsbslkt")
    public suspend fun applicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Application security groups in which the IP configuration is included.
     */
    @JvmName("htmhtejovxrgjxpo")
    public suspend fun applicationSecurityGroups(vararg argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Application security groups in which the IP configuration is included.
     */
    @JvmName("ahvjfoddqdoxuvhq")
    public suspend fun applicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param values Application security groups in which the IP configuration is included.
     */
    @JvmName("qmqkpbjqdxjudbst")
    public suspend fun applicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param value The reference to gateway load balancer frontend IP.
     */
    @JvmName("owgcnuxrynttpmpi")
    public suspend fun gatewayLoadBalancer(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayLoadBalancer = mapped
    }

    /**
     * @param argument The reference to gateway load balancer frontend IP.
     */
    @JvmName("mwqxfxeetoyxxhht")
    public suspend fun gatewayLoadBalancer(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gatewayLoadBalancer = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ukqkowyafcuucwlw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("pmgbxbxrcwqienpg")
    public suspend fun loadBalancerBackendAddressPools(`value`: List<BackendAddressPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("nxpfqcisekwneduk")
    public suspend fun loadBalancerBackendAddressPools(argument: List<suspend BackendAddressPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BackendAddressPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("dsshqtlpxylvsyjy")
    public suspend fun loadBalancerBackendAddressPools(vararg argument: suspend BackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BackendAddressPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("qrachtxhvrmmljkd")
    public suspend fun loadBalancerBackendAddressPools(argument: suspend BackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BackendAddressPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param values The reference to LoadBalancerBackendAddressPool resource.
     */
    @JvmName("uuivttyahxehtwix")
    public suspend fun loadBalancerBackendAddressPools(vararg values: BackendAddressPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param value A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("uoxiqkvoynxenipw")
    public suspend fun loadBalancerInboundNatRules(`value`: List<InboundNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerInboundNatRules = mapped
    }

    /**
     * @param argument A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("svhpujegkospagqx")
    public suspend fun loadBalancerInboundNatRules(argument: List<suspend InboundNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerInboundNatRules = mapped
    }

    /**
     * @param argument A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("owdeqqbloopasjvt")
    public suspend fun loadBalancerInboundNatRules(vararg argument: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerInboundNatRules = mapped
    }

    /**
     * @param argument A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("fawhxtsduqkwuemq")
    public suspend fun loadBalancerInboundNatRules(argument: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancerInboundNatRules = mapped
    }

    /**
     * @param values A list of references of LoadBalancerInboundNatRules.
     */
    @JvmName("ugsecxirfchfnokc")
    public suspend fun loadBalancerInboundNatRules(vararg values: InboundNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerInboundNatRules = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("yvbvcpijdavjmbdx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether this is a primary customer address on the network interface.
     */
    @JvmName("xeaiarrshoirebhc")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value Private IP address of the IP configuration.
     */
    @JvmName("uafwmpghvfmqhbyu")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("neujctfbgvkcesvk")
    public suspend fun privateIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("avbnxctitlkgdvrn")
    public fun privateIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("yjjvjmbnywxljmgt")
    public fun privateIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("rhmdcwoealugbdyn")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("tbydecrarhstjyuf")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("ifxfjwaulotfsbxj")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Public IP address bound to the IP configuration.
     */
    @JvmName("fmsbsitcrutxlgfr")
    public suspend fun publicIPAddress(`value`: PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument Public IP address bound to the IP configuration.
     */
    @JvmName("ttfwrcsykukswvtu")
    public suspend fun publicIPAddress(argument: suspend PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value Subnet bound to the IP configuration.
     */
    @JvmName("syqbudbrlbrwwebf")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Subnet bound to the IP configuration.
     */
    @JvmName("roiatlfhntcdqtto")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("nqkvwwjoldjdvalk")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The reference to Virtual Network Taps.
     */
    @JvmName("bheckokspmevbsgy")
    public suspend fun virtualNetworkTaps(`value`: List<VirtualNetworkTapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkTaps = mapped
    }

    /**
     * @param argument The reference to Virtual Network Taps.
     */
    @JvmName("asrkaiidbrtqmvtf")
    public suspend fun virtualNetworkTaps(argument: List<suspend VirtualNetworkTapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkTapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkTaps = mapped
    }

    /**
     * @param argument The reference to Virtual Network Taps.
     */
    @JvmName("mttrfdjghetqvnax")
    public suspend fun virtualNetworkTaps(vararg argument: suspend VirtualNetworkTapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkTapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkTaps = mapped
    }

    /**
     * @param argument The reference to Virtual Network Taps.
     */
    @JvmName("viiveeqqjtbfbvce")
    public suspend fun virtualNetworkTaps(argument: suspend VirtualNetworkTapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkTapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkTaps = mapped
    }

    /**
     * @param values The reference to Virtual Network Taps.
     */
    @JvmName("nohxteoaqxplxayr")
    public suspend fun virtualNetworkTaps(vararg values: VirtualNetworkTapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkTaps = mapped
    }

    internal fun build(): NetworkInterfaceIPConfigurationArgs = NetworkInterfaceIPConfigurationArgs(
        applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools,
        applicationSecurityGroups = applicationSecurityGroups,
        gatewayLoadBalancer = gatewayLoadBalancer,
        id = id,
        loadBalancerBackendAddressPools = loadBalancerBackendAddressPools,
        loadBalancerInboundNatRules = loadBalancerInboundNatRules,
        name = name,
        primary = primary,
        privateIPAddress = privateIPAddress,
        privateIPAddressVersion = privateIPAddressVersion,
        privateIPAllocationMethod = privateIPAllocationMethod,
        publicIPAddress = publicIPAddress,
        subnet = subnet,
        type = type,
        virtualNetworkTaps = virtualNetworkTaps,
    )
}
