@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkManagerSecurityGroupItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network manager security group item.
 * @property networkGroupId Network manager group Id.
 */
public data class NetworkManagerSecurityGroupItemArgs(
    public val networkGroupId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkManagerSecurityGroupItemArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NetworkManagerSecurityGroupItemArgs =
        com.pulumi.azurenative.network.inputs.NetworkManagerSecurityGroupItemArgs.builder()
            .networkGroupId(networkGroupId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkManagerSecurityGroupItemArgs].
 */
@PulumiTagMarker
public class NetworkManagerSecurityGroupItemArgsBuilder internal constructor() {
    private var networkGroupId: Output<String>? = null

    /**
     * @param value Network manager group Id.
     */
    @JvmName("xvbaqosbsiaovtek")
    public suspend fun networkGroupId(`value`: Output<String>) {
        this.networkGroupId = value
    }

    /**
     * @param value Network manager group Id.
     */
    @JvmName("sxwgoxgawjimmrrf")
    public suspend fun networkGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkGroupId = mapped
    }

    internal fun build(): NetworkManagerSecurityGroupItemArgs = NetworkManagerSecurityGroupItemArgs(
        networkGroupId = networkGroupId ?: throw PulumiNullFieldException("networkGroupId"),
    )
}
