@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyRuleNetworkProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule of type network.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationFqdns List of destination FQDNs.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleNetworkProtocols.
 * @property name Name of the rule.
 * @property ruleType Rule Type.
 * Expected value is 'NetworkRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class NetworkRuleArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationFqdns: Output<List<String>>? = null,
    public val destinationIpGroups: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val ipProtocols: Output<List<Either<String, FirewallPolicyRuleNetworkProtocol>>>? = null,
    public val name: Output<String>? = null,
    public val ruleType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NetworkRuleArgs =
        com.pulumi.azurenative.network.inputs.NetworkRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationFqdns(destinationFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationIpGroups(destinationIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipProtocols(
                ipProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkRuleArgs].
 */
@PulumiTagMarker
public class NetworkRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationFqdns: Output<List<String>>? = null

    private var destinationIpGroups: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var ipProtocols: Output<List<Either<String, FirewallPolicyRuleNetworkProtocol>>>? = null

    private var name: Output<String>? = null

    private var ruleType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("iighwmryibrpxrxp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("ywwkneggrhfrujox")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("dyhrrrkupptuewyn")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("cmmtnfulnwxssrjm")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination FQDNs.
     */
    @JvmName("hacibtbqrsenbwtr")
    public suspend fun destinationFqdns(`value`: Output<List<String>>) {
        this.destinationFqdns = value
    }

    @JvmName("efkvawjquxnxiyay")
    public suspend fun destinationFqdns(vararg values: Output<String>) {
        this.destinationFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of destination FQDNs.
     */
    @JvmName("ohdkdukvoktvjfqa")
    public suspend fun destinationFqdns(values: List<Output<String>>) {
        this.destinationFqdns = Output.all(values)
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("ycvjndhvktrmsxju")
    public suspend fun destinationIpGroups(`value`: Output<List<String>>) {
        this.destinationIpGroups = value
    }

    @JvmName("mpgisefnrpmxidxg")
    public suspend fun destinationIpGroups(vararg values: Output<String>) {
        this.destinationIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("lgqfiivbexgrqubm")
    public suspend fun destinationIpGroups(values: List<Output<String>>) {
        this.destinationIpGroups = Output.all(values)
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("nyangkvabeosnghs")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("piwujkpynxtkowxq")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("ybqaiveixcgokypl")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("qrprldyogofevqqv")
    public suspend fun ipProtocols(`value`: Output<List<Either<String, FirewallPolicyRuleNetworkProtocol>>>) {
        this.ipProtocols = value
    }

    @JvmName("uosttahesfhtlvjq")
    public suspend fun ipProtocols(vararg values: Output<Either<String, FirewallPolicyRuleNetworkProtocol>>) {
        this.ipProtocols = Output.all(values.asList())
    }

    /**
     * @param values Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("iabjtgaiwkluweip")
    public suspend fun ipProtocols(values: List<Output<Either<String, FirewallPolicyRuleNetworkProtocol>>>) {
        this.ipProtocols = Output.all(values)
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("txkvyrouydyovptu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule Type.
     * Expected value is 'NetworkRule'.
     */
    @JvmName("cwqpvqsrvrdywjnw")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("denrgjqgvxmykopq")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("ryflfceimwohwlvi")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("paxloeqvhycmqpsw")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("srxaymhhhnfpfnme")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("rolfvltgavstcamx")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("msmmfpfxwkwcvrro")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("uqncppkurkscdtwk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("antpdlwetopdshdx")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("qsjcqecrpwhepiqj")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination FQDNs.
     */
    @JvmName("uixhpiwkxudpxjln")
    public suspend fun destinationFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationFqdns = mapped
    }

    /**
     * @param values List of destination FQDNs.
     */
    @JvmName("xwxehpgvlbftuywn")
    public suspend fun destinationFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationFqdns = mapped
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("qpiwxgshcswjavse")
    public suspend fun destinationIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("csxnlbekaiyiqtvd")
    public suspend fun destinationIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("webcyohpkqxmjabo")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("rsqqlkwijjpdjewd")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("woxdrgyimjmuswya")
    public suspend fun ipProtocols(`value`: List<Either<String, FirewallPolicyRuleNetworkProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param values Array of FirewallPolicyRuleNetworkProtocols.
     */
    @JvmName("hpkxijphicujqwfp")
    public suspend fun ipProtocols(vararg values: Either<String, FirewallPolicyRuleNetworkProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param value Name of the rule.
     */
    @JvmName("vfpnfcbgjkuymtsk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule Type.
     * Expected value is 'NetworkRule'.
     */
    @JvmName("afnhbvptxdfcbdvu")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("rmioglgxtgxjdgfh")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("nnrjylvicgegdtql")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("psfowarqkpioivfq")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("odhvbdqsvgqqxghf")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    internal fun build(): NetworkRuleArgs = NetworkRuleArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        destinationFqdns = destinationFqdns,
        destinationIpGroups = destinationIpGroups,
        destinationPorts = destinationPorts,
        ipProtocols = ipProtocols,
        name = name,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
    )
}
