@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VPN client revoked certificate of P2SVpnServerConfiguration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property thumbprint The revoked VPN client certificate thumbprint.
 */
public data class P2SVpnServerConfigVpnClientRevokedCertificateArgs(
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs =
        com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs.builder()
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [P2SVpnServerConfigVpnClientRevokedCertificateArgs].
 */
@PulumiTagMarker
public class P2SVpnServerConfigVpnClientRevokedCertificateArgsBuilder internal constructor() {
    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("xtocctylpwmrctoe")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hpimifncpkphvgpw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("jjcqqjkirdumtogs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The revoked VPN client certificate thumbprint.
     */
    @JvmName("ewuwkybjowriuojr")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("yvqimgyxvpkrwiyi")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bwyaforcgrkqadjb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("vrgljxsmfhwwcyge")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The revoked VPN client certificate thumbprint.
     */
    @JvmName("gxryhyiyorefsrmn")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): P2SVpnServerConfigVpnClientRevokedCertificateArgs =
        P2SVpnServerConfigVpnClientRevokedCertificateArgs(
            etag = etag,
            id = id,
            name = name,
            thumbprint = thumbprint,
        )
}
