@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PacketCaptureMachineScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
 * @property exclude List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
 * @property include List of AzureVMSS instances to run packet capture on.
 */
public data class PacketCaptureMachineScopeArgs(
    public val exclude: Output<List<String>>? = null,
    public val include: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PacketCaptureMachineScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PacketCaptureMachineScopeArgs =
        com.pulumi.azurenative.network.inputs.PacketCaptureMachineScopeArgs.builder()
            .exclude(exclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .include(include?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PacketCaptureMachineScopeArgs].
 */
@PulumiTagMarker
public class PacketCaptureMachineScopeArgsBuilder internal constructor() {
    private var exclude: Output<List<String>>? = null

    private var include: Output<List<String>>? = null

    /**
     * @param value List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
     */
    @JvmName("sjgewuerimhnbcey")
    public suspend fun exclude(`value`: Output<List<String>>) {
        this.exclude = value
    }

    @JvmName("xyvnkhpybhbciaah")
    public suspend fun exclude(vararg values: Output<String>) {
        this.exclude = Output.all(values.asList())
    }

    /**
     * @param values List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
     */
    @JvmName("bgngunrmqvgobdnw")
    public suspend fun exclude(values: List<Output<String>>) {
        this.exclude = Output.all(values)
    }

    /**
     * @param value List of AzureVMSS instances to run packet capture on.
     */
    @JvmName("vpsymkdrsfsnwblm")
    public suspend fun include(`value`: Output<List<String>>) {
        this.include = value
    }

    @JvmName("yhjmscamhqwdqcbx")
    public suspend fun include(vararg values: Output<String>) {
        this.include = Output.all(values.asList())
    }

    /**
     * @param values List of AzureVMSS instances to run packet capture on.
     */
    @JvmName("kbvhixnwjjmousmo")
    public suspend fun include(values: List<Output<String>>) {
        this.include = Output.all(values)
    }

    /**
     * @param value List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
     */
    @JvmName("elilrmvnxtemtraa")
    public suspend fun exclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param values List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
     */
    @JvmName("dckelpbxkgmbocrd")
    public suspend fun exclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param value List of AzureVMSS instances to run packet capture on.
     */
    @JvmName("dcyynvexkurbtoha")
    public suspend fun include(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param values List of AzureVMSS instances to run packet capture on.
     */
    @JvmName("qfmlxpeypxridlen")
    public suspend fun include(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.include = mapped
    }

    internal fun build(): PacketCaptureMachineScopeArgs = PacketCaptureMachineScopeArgs(
        exclude = exclude,
        include = include,
    )
}
