@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateDnsZoneConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * PrivateDnsZoneConfig resource.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateDnsZoneId The resource id of the private dns zone.
 */
public data class PrivateDnsZoneConfigArgs(
    public val name: Output<String>? = null,
    public val privateDnsZoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateDnsZoneConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateDnsZoneConfigArgs =
        com.pulumi.azurenative.network.inputs.PrivateDnsZoneConfigArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .privateDnsZoneId(privateDnsZoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateDnsZoneConfigArgs].
 */
@PulumiTagMarker
public class PrivateDnsZoneConfigArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var privateDnsZoneId: Output<String>? = null

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("coitseynycsjvrsf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource id of the private dns zone.
     */
    @JvmName("imjrttxglgpjjehk")
    public suspend fun privateDnsZoneId(`value`: Output<String>) {
        this.privateDnsZoneId = value
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("pfyckkifoowltdfn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource id of the private dns zone.
     */
    @JvmName("qkklancxnscnsnvj")
    public suspend fun privateDnsZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsZoneId = mapped
    }

    internal fun build(): PrivateDnsZoneConfigArgs = PrivateDnsZoneConfigArgs(
        name = name,
        privateDnsZoneId = privateDnsZoneId,
    )
}
