@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateEndpointIPConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An IP Configuration of the private endpoint.
 * @property groupId The ID of a group obtained from the remote resource that this private endpoint should connect to.
 * @property memberName The member name of a group obtained from the remote resource that this private endpoint should connect to.
 * @property name The name of the resource that is unique within a resource group.
 * @property privateIPAddress A private ip address obtained from the private endpoint's subnet.
 */
public data class PrivateEndpointIPConfigurationArgs(
    public val groupId: Output<String>? = null,
    public val memberName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateIPAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateEndpointIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateEndpointIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.PrivateEndpointIPConfigurationArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .memberName(memberName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointIPConfigurationArgs].
 */
@PulumiTagMarker
public class PrivateEndpointIPConfigurationArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var memberName: Output<String>? = null

    private var name: Output<String>? = null

    private var privateIPAddress: Output<String>? = null

    /**
     * @param value The ID of a group obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("fywrkfbwfkqpiocy")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The member name of a group obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("fpblugfhokfxujct")
    public suspend fun memberName(`value`: Output<String>) {
        this.memberName = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group.
     */
    @JvmName("txydtwomvsytkpdo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A private ip address obtained from the private endpoint's subnet.
     */
    @JvmName("xrmrwajyfbseihpq")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The ID of a group obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("qhclgppjwbfndivg")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The member name of a group obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("cbvsovislcgkkyts")
    public suspend fun memberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberName = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group.
     */
    @JvmName("mnxlcxirpbojakog")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A private ip address obtained from the private endpoint's subnet.
     */
    @JvmName("setcdhdtpmbgkovb")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    internal fun build(): PrivateEndpointIPConfigurationArgs = PrivateEndpointIPConfigurationArgs(
        groupId = groupId,
        memberName = memberName,
        name = name,
        privateIPAddress = privateIPAddress,
    )
}
