@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PropagatedRouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The list of RouteTables to advertise the routes to.
 * @property ids The list of resource ids of all the RouteTables.
 * @property labels The list of labels.
 */
public data class PropagatedRouteTableArgs(
    public val ids: Output<List<SubResourceArgs>>? = null,
    public val labels: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PropagatedRouteTableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PropagatedRouteTableArgs =
        com.pulumi.azurenative.network.inputs.PropagatedRouteTableArgs.builder()
            .ids(ids?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PropagatedRouteTableArgs].
 */
@PulumiTagMarker
public class PropagatedRouteTableArgsBuilder internal constructor() {
    private var ids: Output<List<SubResourceArgs>>? = null

    private var labels: Output<List<String>>? = null

    /**
     * @param value The list of resource ids of all the RouteTables.
     */
    @JvmName("aanblobkwcvssejx")
    public suspend fun ids(`value`: Output<List<SubResourceArgs>>) {
        this.ids = value
    }

    @JvmName("uxodxbhesfbfthpd")
    public suspend fun ids(vararg values: Output<SubResourceArgs>) {
        this.ids = Output.all(values.asList())
    }

    /**
     * @param values The list of resource ids of all the RouteTables.
     */
    @JvmName("dusscmtwdiiulxoa")
    public suspend fun ids(values: List<Output<SubResourceArgs>>) {
        this.ids = Output.all(values)
    }

    /**
     * @param value The list of labels.
     */
    @JvmName("wfcggojicupsnsqr")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("diiwpumqsfaydejr")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The list of labels.
     */
    @JvmName("fsdyrwkygstmwxmd")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The list of resource ids of all the RouteTables.
     */
    @JvmName("ndktcgthbtuknscg")
    public suspend fun ids(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ids = mapped
    }

    /**
     * @param argument The list of resource ids of all the RouteTables.
     */
    @JvmName("amibhaxksuvbwgoc")
    public suspend fun ids(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param argument The list of resource ids of all the RouteTables.
     */
    @JvmName("msgksafmjuykkmtk")
    public suspend fun ids(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param argument The list of resource ids of all the RouteTables.
     */
    @JvmName("oqyvjkjffciylyan")
    public suspend fun ids(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param values The list of resource ids of all the RouteTables.
     */
    @JvmName("htmmicgrpqsreyxy")
    public suspend fun ids(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ids = mapped
    }

    /**
     * @param value The list of labels.
     */
    @JvmName("tnhgpnniyvtuvasv")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values The list of labels.
     */
    @JvmName("muekoqdlqfrknqdx")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    internal fun build(): PropagatedRouteTableArgs = PropagatedRouteTableArgs(
        ids = ids,
        labels = labels,
    )
}
