@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PtrRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A PTR record.
 * @property ptrdname The PTR target domain name for this PTR record.
 */
public data class PtrRecordArgs(
    public val ptrdname: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PtrRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PtrRecordArgs =
        com.pulumi.azurenative.network.inputs.PtrRecordArgs.builder()
            .ptrdname(ptrdname?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PtrRecordArgs].
 */
@PulumiTagMarker
public class PtrRecordArgsBuilder internal constructor() {
    private var ptrdname: Output<String>? = null

    /**
     * @param value The PTR target domain name for this PTR record.
     */
    @JvmName("xfpesfskeqnkllhk")
    public suspend fun ptrdname(`value`: Output<String>) {
        this.ptrdname = value
    }

    /**
     * @param value The PTR target domain name for this PTR record.
     */
    @JvmName("xvlwdcvanhrvkaqu")
    public suspend fun ptrdname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ptrdname = mapped
    }

    internal fun build(): PtrRecordArgs = PtrRecordArgs(
        ptrdname = ptrdname,
    )
}
