@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PublicIPAddressSkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.PublicIPAddressSkuName
import com.pulumi.azurenative.network.kotlin.enums.PublicIPAddressSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of a public IP address.
 * @property name Name of a public IP address SKU.
 * @property tier Tier of a public IP address SKU.
 */
public data class PublicIPAddressSkuArgs(
    public val name: Output<Either<String, PublicIPAddressSkuName>>? = null,
    public val tier: Output<Either<String, PublicIPAddressSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PublicIPAddressSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PublicIPAddressSkuArgs =
        com.pulumi.azurenative.network.inputs.PublicIPAddressSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PublicIPAddressSkuArgs].
 */
@PulumiTagMarker
public class PublicIPAddressSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, PublicIPAddressSkuName>>? = null

    private var tier: Output<Either<String, PublicIPAddressSkuTier>>? = null

    /**
     * @param value Name of a public IP address SKU.
     */
    @JvmName("sxecsmpoeqxayfcd")
    public suspend fun name(`value`: Output<Either<String, PublicIPAddressSkuName>>) {
        this.name = value
    }

    /**
     * @param value Tier of a public IP address SKU.
     */
    @JvmName("qaeeeoikpsfpspyl")
    public suspend fun tier(`value`: Output<Either<String, PublicIPAddressSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Name of a public IP address SKU.
     */
    @JvmName("omawaelfdlwfusvf")
    public suspend fun name(`value`: Either<String, PublicIPAddressSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of a public IP address SKU.
     */
    @JvmName("apppuvvmyhhglbcu")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAddressSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of a public IP address SKU.
     */
    @JvmName("ufieabrlqktcmrfk")
    public fun name(`value`: PublicIPAddressSkuName) {
        val toBeMapped = Either.ofRight<String, PublicIPAddressSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of a public IP address SKU.
     */
    @JvmName("ckserjrovxphxrfp")
    public suspend fun tier(`value`: Either<String, PublicIPAddressSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of a public IP address SKU.
     */
    @JvmName("hjdqoikdkutqajrj")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAddressSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of a public IP address SKU.
     */
    @JvmName("njxanwsmvredetwa")
    public fun tier(`value`: PublicIPAddressSkuTier) {
        val toBeMapped = Either.ofRight<String, PublicIPAddressSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): PublicIPAddressSkuArgs = PublicIPAddressSkuArgs(
        name = name,
        tier = tier,
    )
}
