@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.QosDefinitionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Quality of Service defines the traffic configuration between endpoints. Mandatory to have one marking.
 * @property destinationIpRanges Destination IP ranges.
 * @property destinationPortRanges Destination port ranges.
 * @property markings List of markings to be used in the configuration.
 * @property protocol RNM supported protocol types.
 * @property sourceIpRanges Source IP ranges.
 * @property sourcePortRanges Sources port ranges.
 */
public data class QosDefinitionArgs(
    public val destinationIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val destinationPortRanges: Output<List<QosPortRangeArgs>>? = null,
    public val markings: Output<List<Int>>? = null,
    public val protocol: Output<Either<String, ProtocolType>>? = null,
    public val sourceIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val sourcePortRanges: Output<List<QosPortRangeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.QosDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.QosDefinitionArgs =
        com.pulumi.azurenative.network.inputs.QosDefinitionArgs.builder()
            .destinationIpRanges(
                destinationIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destinationPortRanges(
                destinationPortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .markings(markings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceIpRanges(
                sourceIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourcePortRanges(
                sourcePortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [QosDefinitionArgs].
 */
@PulumiTagMarker
public class QosDefinitionArgsBuilder internal constructor() {
    private var destinationIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var destinationPortRanges: Output<List<QosPortRangeArgs>>? = null

    private var markings: Output<List<Int>>? = null

    private var protocol: Output<Either<String, ProtocolType>>? = null

    private var sourceIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var sourcePortRanges: Output<List<QosPortRangeArgs>>? = null

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("fdpdvvtwdtxulvmq")
    public suspend fun destinationIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.destinationIpRanges = value
    }

    @JvmName("wtnupawsvsvufdnc")
    public suspend fun destinationIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.destinationIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("qdldhgorfgdfmgnp")
    public suspend fun destinationIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.destinationIpRanges = Output.all(values)
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("qjkxidljqwbcaixp")
    public suspend fun destinationPortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.destinationPortRanges = value
    }

    @JvmName("skddwtuedftbyubj")
    public suspend fun destinationPortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("cawhygllmjbnfcmt")
    public suspend fun destinationPortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("kknwpiemrwnhswar")
    public suspend fun markings(`value`: Output<List<Int>>) {
        this.markings = value
    }

    @JvmName("gpmherekrxolrmex")
    public suspend fun markings(vararg values: Output<Int>) {
        this.markings = Output.all(values.asList())
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("fpfdxeggreenwfqs")
    public suspend fun markings(values: List<Output<Int>>) {
        this.markings = Output.all(values)
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("bqiffyjftfmgyrkx")
    public suspend fun protocol(`value`: Output<Either<String, ProtocolType>>) {
        this.protocol = value
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("ijksrlcyhydunati")
    public suspend fun sourceIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.sourceIpRanges = value
    }

    @JvmName("peegannunevnssmo")
    public suspend fun sourceIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.sourceIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("qqcnwbthjspgidlh")
    public suspend fun sourceIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.sourceIpRanges = Output.all(values)
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("aujtntmjdqfrxeka")
    public suspend fun sourcePortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.sourcePortRanges = value
    }

    @JvmName("dcagjernaimrscdn")
    public suspend fun sourcePortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("bepafalstosvqamm")
    public suspend fun sourcePortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("mcgxqfkxhsgvufqh")
    public suspend fun destinationIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("rhiygumjroeimkat")
    public suspend fun destinationIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("oraocejfduwlliai")
    public suspend fun destinationIpRanges(vararg argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("nnkdxgeacrwublko")
    public suspend fun destinationIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("tlibrxfflawqcpru")
    public suspend fun destinationIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("fwxidxphfayqtukx")
    public suspend fun destinationPortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("vnnajrkwgtpnynki")
    public suspend fun destinationPortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("ivgnmttubgsjuexe")
    public suspend fun destinationPortRanges(vararg argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("iorruimkpjkudlsx")
    public suspend fun destinationPortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("hdoqwnnlsptaaqkb")
    public suspend fun destinationPortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("jsbhkdmxwicdwfcv")
    public suspend fun markings(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("tcqewophnggatevn")
    public suspend fun markings(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("bijjrqgteokcpbsu")
    public suspend fun protocol(`value`: Either<String, ProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("aqxvyggxkhvmnyke")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("hxolvqjhydfmyjkk")
    public fun protocol(`value`: ProtocolType) {
        val toBeMapped = Either.ofRight<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("isyvftxlodriiccm")
    public suspend fun sourceIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("hadfvtanvymvplhg")
    public suspend fun sourceIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("mbpybbpmivsdihca")
    public suspend fun sourceIpRanges(vararg argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("eyfvatucvfgivbck")
    public suspend fun sourceIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("ecprcklbliklcobq")
    public suspend fun sourceIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("jsovgrxswfgflreq")
    public suspend fun sourcePortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("ddshtywyeqlrhtfk")
    public suspend fun sourcePortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("rallbblrwlgrnupp")
    public suspend fun sourcePortRanges(vararg argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("ffjpbrulsaqprflk")
    public suspend fun sourcePortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("jqjjyxaqfkvxhgtv")
    public suspend fun sourcePortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    internal fun build(): QosDefinitionArgs = QosDefinitionArgs(
        destinationIpRanges = destinationIpRanges,
        destinationPortRanges = destinationPortRanges,
        markings = markings,
        protocol = protocol,
        sourceIpRanges = sourceIpRanges,
        sourcePortRanges = sourcePortRanges,
    )
}
