@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RedirectConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorRedirectProtocol
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorRedirectType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes Redirect Route.
 * @property customFragment Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
 * @property customHost Host to redirect. Leave empty to use the incoming host as the destination host.
 * @property customPath The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
 * @property customQueryString The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
 * @property odataType
 * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
 * @property redirectProtocol The protocol of the destination to where the traffic is redirected
 * @property redirectType The redirect type the rule will use when redirecting traffic.
 */
public data class RedirectConfigurationArgs(
    public val customFragment: Output<String>? = null,
    public val customHost: Output<String>? = null,
    public val customPath: Output<String>? = null,
    public val customQueryString: Output<String>? = null,
    public val odataType: Output<String>,
    public val redirectProtocol: Output<Either<String, FrontDoorRedirectProtocol>>? = null,
    public val redirectType: Output<Either<String, FrontDoorRedirectType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RedirectConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RedirectConfigurationArgs =
        com.pulumi.azurenative.network.inputs.RedirectConfigurationArgs.builder()
            .customFragment(customFragment?.applyValue({ args0 -> args0 }))
            .customHost(customHost?.applyValue({ args0 -> args0 }))
            .customPath(customPath?.applyValue({ args0 -> args0 }))
            .customQueryString(customQueryString?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .redirectProtocol(
                redirectProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .redirectType(
                redirectType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RedirectConfigurationArgs].
 */
@PulumiTagMarker
public class RedirectConfigurationArgsBuilder internal constructor() {
    private var customFragment: Output<String>? = null

    private var customHost: Output<String>? = null

    private var customPath: Output<String>? = null

    private var customQueryString: Output<String>? = null

    private var odataType: Output<String>? = null

    private var redirectProtocol: Output<Either<String, FrontDoorRedirectProtocol>>? = null

    private var redirectType: Output<Either<String, FrontDoorRedirectType>>? = null

    /**
     * @param value Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
     */
    @JvmName("mhemrityocjxlyaf")
    public suspend fun customFragment(`value`: Output<String>) {
        this.customFragment = value
    }

    /**
     * @param value Host to redirect. Leave empty to use the incoming host as the destination host.
     */
    @JvmName("hcqqavyntbkiuvdu")
    public suspend fun customHost(`value`: Output<String>) {
        this.customHost = value
    }

    /**
     * @param value The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
     */
    @JvmName("vojmblxfkhokhqox")
    public suspend fun customPath(`value`: Output<String>) {
        this.customPath = value
    }

    /**
     * @param value The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
     */
    @JvmName("idoincdmmgqucgfj")
    public suspend fun customQueryString(`value`: Output<String>) {
        this.customQueryString = value
    }

    /**
     * @param value
     * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
     */
    @JvmName("vkruvqeuurerbdcp")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The protocol of the destination to where the traffic is redirected
     */
    @JvmName("ijojfxvervesltit")
    public suspend fun redirectProtocol(`value`: Output<Either<String, FrontDoorRedirectProtocol>>) {
        this.redirectProtocol = value
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("xbmocwbwjorqieay")
    public suspend fun redirectType(`value`: Output<Either<String, FrontDoorRedirectType>>) {
        this.redirectType = value
    }

    /**
     * @param value Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
     */
    @JvmName("arrhuuqgoxiovtiy")
    public suspend fun customFragment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFragment = mapped
    }

    /**
     * @param value Host to redirect. Leave empty to use the incoming host as the destination host.
     */
    @JvmName("hvesygybdgrbsybl")
    public suspend fun customHost(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHost = mapped
    }

    /**
     * @param value The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
     */
    @JvmName("klthemvnueydrahv")
    public suspend fun customPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPath = mapped
    }

    /**
     * @param value The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
     */
    @JvmName("untinsxwjgwhajss")
    public suspend fun customQueryString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customQueryString = mapped
    }

    /**
     * @param value
     * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
     */
    @JvmName("gyfgieapdrbcrcmc")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The protocol of the destination to where the traffic is redirected
     */
    @JvmName("tqojxiyeulushyeu")
    public suspend fun redirectProtocol(`value`: Either<String, FrontDoorRedirectProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectProtocol = mapped
    }

    /**
     * @param value The protocol of the destination to where the traffic is redirected
     */
    @JvmName("xonslqkvjabbwlqe")
    public fun redirectProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorRedirectProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectProtocol = mapped
    }

    /**
     * @param value The protocol of the destination to where the traffic is redirected
     */
    @JvmName("oireivbtvgyibqtp")
    public fun redirectProtocol(`value`: FrontDoorRedirectProtocol) {
        val toBeMapped = Either.ofRight<String, FrontDoorRedirectProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectProtocol = mapped
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("nrcijjftnyiqgvvl")
    public suspend fun redirectType(`value`: Either<String, FrontDoorRedirectType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("fyscmbdmmsbgfuym")
    public fun redirectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorRedirectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    /**
     * @param value The redirect type the rule will use when redirecting traffic.
     */
    @JvmName("cxuynvjytvtibtqf")
    public fun redirectType(`value`: FrontDoorRedirectType) {
        val toBeMapped = Either.ofRight<String, FrontDoorRedirectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectType = mapped
    }

    internal fun build(): RedirectConfigurationArgs = RedirectConfigurationArgs(
        customFragment = customFragment,
        customHost = customHost,
        customPath = customPath,
        customQueryString = customQueryString,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        redirectProtocol = redirectProtocol,
        redirectType = redirectType,
    )
}
