@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RetentionPolicyParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters that define the retention policy for flow log.
 * @property days Number of days to retain flow log records.
 * @property enabled Flag to enable/disable retention.
 */
public data class RetentionPolicyParametersArgs(
    public val days: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RetentionPolicyParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RetentionPolicyParametersArgs =
        com.pulumi.azurenative.network.inputs.RetentionPolicyParametersArgs.builder()
            .days(days?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RetentionPolicyParametersArgs].
 */
@PulumiTagMarker
public class RetentionPolicyParametersArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Number of days to retain flow log records.
     */
    @JvmName("xmasqbqtqglldhaf")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Flag to enable/disable retention.
     */
    @JvmName("nafhmkqkvpgwdbpc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Number of days to retain flow log records.
     */
    @JvmName("fphviprdekgjnpkf")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Flag to enable/disable retention.
     */
    @JvmName("xuxnpxcujjwvnalp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): RetentionPolicyParametersArgs = RetentionPolicyParametersArgs(
        days = days,
        enabled = enabled,
    )
}
