@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SecurityRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleAccess
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleDirection
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network security rule.
 * @property access The network traffic is allowed or denied.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationAddressPrefix The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
 * @property destinationAddressPrefixes The destination address prefixes. CIDR or destination IP ranges.
 * @property destinationApplicationSecurityGroups The application security group specified as destination.
 * @property destinationPortRange The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property destinationPortRanges The destination port ranges.
 * @property direction The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property provisioningState The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property sourceAddressPrefix The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
 * @property sourceAddressPrefixes The CIDR or source IP ranges.
 * @property sourceApplicationSecurityGroups The application security group specified as source.
 * @property sourcePortRange The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property sourcePortRanges The source port ranges.
 * @property type The type of the resource.
 */
public data class SecurityRuleArgs(
    public val access: Output<Either<String, SecurityRuleAccess>>,
    public val description: Output<String>? = null,
    public val destinationAddressPrefix: Output<String>? = null,
    public val destinationAddressPrefixes: Output<List<String>>? = null,
    public val destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? =
        null,
    public val destinationPortRange: Output<String>? = null,
    public val destinationPortRanges: Output<List<String>>? = null,
    public val direction: Output<Either<String, SecurityRuleDirection>>,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<Either<String, SecurityRuleProtocol>>,
    public val provisioningState: Output<String>? = null,
    public val sourceAddressPrefix: Output<String>? = null,
    public val sourceAddressPrefixes: Output<List<String>>? = null,
    public val sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val sourcePortRanges: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SecurityRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SecurityRuleArgs =
        com.pulumi.azurenative.network.inputs.SecurityRuleArgs.builder()
            .access(
                access.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefix(destinationAddressPrefix?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefixes(
                destinationAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .destinationApplicationSecurityGroups(
                destinationApplicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .destinationPortRanges(destinationPortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefix(sourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefixes(sourceAddressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceApplicationSecurityGroups(
                sourceApplicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityRuleArgs].
 */
@PulumiTagMarker
public class SecurityRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, SecurityRuleAccess>>? = null

    private var description: Output<String>? = null

    private var destinationAddressPrefix: Output<String>? = null

    private var destinationAddressPrefixes: Output<List<String>>? = null

    private var destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? =
        null

    private var destinationPortRange: Output<String>? = null

    private var destinationPortRanges: Output<List<String>>? = null

    private var direction: Output<Either<String, SecurityRuleDirection>>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<Either<String, SecurityRuleProtocol>>? = null

    private var provisioningState: Output<String>? = null

    private var sourceAddressPrefix: Output<String>? = null

    private var sourceAddressPrefixes: Output<List<String>>? = null

    private var sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null

    private var sourcePortRange: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("crksjvusnnplgwlh")
    public suspend fun access(`value`: Output<Either<String, SecurityRuleAccess>>) {
        this.access = value
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("etocqbhqnwwwstvj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("tkqstjuwwqwkmcle")
    public suspend fun destinationAddressPrefix(`value`: Output<String>) {
        this.destinationAddressPrefix = value
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("fxblcnenyxuolung")
    public suspend fun destinationAddressPrefixes(`value`: Output<List<String>>) {
        this.destinationAddressPrefixes = value
    }

    @JvmName("lbeohexqytgulvmm")
    public suspend fun destinationAddressPrefixes(vararg values: Output<String>) {
        this.destinationAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("mhquhrgauilbyclw")
    public suspend fun destinationAddressPrefixes(values: List<Output<String>>) {
        this.destinationAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The application security group specified as destination.
     */
    @JvmName("orosdxiunuxtlsmc")
    public suspend fun destinationApplicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.destinationApplicationSecurityGroups = value
    }

    @JvmName("xtkvgymgpfutvtua")
    public suspend fun destinationApplicationSecurityGroups(vararg values: Output<ApplicationSecurityGroupArgs>) {
        this.destinationApplicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values The application security group specified as destination.
     */
    @JvmName("dxrvidrpglexidxh")
    public suspend fun destinationApplicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.destinationApplicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("qcqwyemrwdkcphuq")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("iqwjjnvlbtniskfh")
    public suspend fun destinationPortRanges(`value`: Output<List<String>>) {
        this.destinationPortRanges = value
    }

    @JvmName("uogeftmfevdopbwo")
    public suspend fun destinationPortRanges(vararg values: Output<String>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("yqpwimieihkyefbt")
    public suspend fun destinationPortRanges(values: List<Output<String>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("vopltrwhdvmddnon")
    public suspend fun direction(`value`: Output<Either<String, SecurityRuleDirection>>) {
        this.direction = value
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("rdqenoondjblrmpi")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hvprhawxmhmapesm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("lrtbsymhkvaoyaku")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("velpvxqgyycxqwwp")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("cieeyeyicbeuykwp")
    public suspend fun protocol(`value`: Output<Either<String, SecurityRuleProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("qmyhisahrmlyfxaw")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("ejkspnpfoxyonxds")
    public suspend fun sourceAddressPrefix(`value`: Output<String>) {
        this.sourceAddressPrefix = value
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("kunwgsweuhfwjikl")
    public suspend fun sourceAddressPrefixes(`value`: Output<List<String>>) {
        this.sourceAddressPrefixes = value
    }

    @JvmName("ldxuanakqyebbmry")
    public suspend fun sourceAddressPrefixes(vararg values: Output<String>) {
        this.sourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("lbxtdnoodvkvfaix")
    public suspend fun sourceAddressPrefixes(values: List<Output<String>>) {
        this.sourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The application security group specified as source.
     */
    @JvmName("elfybmlrljkyohli")
    public suspend fun sourceApplicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.sourceApplicationSecurityGroups = value
    }

    @JvmName("nnbphncgfdrpevqi")
    public suspend fun sourceApplicationSecurityGroups(vararg values: Output<ApplicationSecurityGroupArgs>) {
        this.sourceApplicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values The application security group specified as source.
     */
    @JvmName("soxucfjytvmrpksd")
    public suspend fun sourceApplicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.sourceApplicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("wlrythheksbrfgbs")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("qbqlpkjndksrhhlv")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("ycsdljhljbayygio")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("xbcrxafplhhgmeag")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("onlvufmcihdfnolg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("yhsqwuxmonyuidqo")
    public suspend fun access(`value`: Either<String, SecurityRuleAccess>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("ritdtherwplxbwig")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("yjecolgkhcguhewu")
    public fun access(`value`: SecurityRuleAccess) {
        val toBeMapped = Either.ofRight<String, SecurityRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("nmjiierpdywbkwmn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("wjnnpcwqvdidcbgf")
    public suspend fun destinationAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefix = mapped
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("grytbeqcahbktiti")
    public suspend fun destinationAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("gurgyhelhyonxexd")
    public suspend fun destinationAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param value The application security group specified as destination.
     */
    @JvmName("qprgllfgukdcxblo")
    public suspend fun destinationApplicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("hoygogbbdrfxnros")
    public suspend fun destinationApplicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("vxexgpsctlgettbc")
    public suspend fun destinationApplicationSecurityGroups(vararg argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("tsgwflmooowgrvsh")
    public suspend fun destinationApplicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param values The application security group specified as destination.
     */
    @JvmName("umsvmewawtcrhjfn")
    public suspend fun destinationApplicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param value The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("droetpiryckhbpjm")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("qroniroiawmvjtva")
    public suspend fun destinationPortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("mpdvwiaclhjoknsq")
    public suspend fun destinationPortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("xxxynaakjbpgdopr")
    public suspend fun direction(`value`: Either<String, SecurityRuleDirection>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("ewgschfcvurcreuw")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("gjfjisvjtbqyjore")
    public fun direction(`value`: SecurityRuleDirection) {
        val toBeMapped = Either.ofRight<String, SecurityRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("xeghneojhrnbvddo")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("twsstwxaokmoxoji")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("tjmcffqvhtsmlccr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("ygrwmgubxlbscaxu")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("chtxvwxxqhhlkqau")
    public suspend fun protocol(`value`: Either<String, SecurityRuleProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("phrlmccijkljclhq")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("kvnqgoiqsxplykqp")
    public fun protocol(`value`: SecurityRuleProtocol) {
        val toBeMapped = Either.ofRight<String, SecurityRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("jabkxwydbmrgnojl")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("xbjanpheqiitvgqs")
    public suspend fun sourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefix = mapped
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("hkalrgexdiiorfpy")
    public suspend fun sourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("eixjpkhvnanwmtqs")
    public suspend fun sourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param value The application security group specified as source.
     */
    @JvmName("ldkhfultjuyvjksy")
    public suspend fun sourceApplicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("nfnabanccshhyhyy")
    public suspend fun sourceApplicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("wpqgvogksfrpwqqu")
    public suspend fun sourceApplicationSecurityGroups(vararg argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("pcdxuulgoayikpwk")
    public suspend fun sourceApplicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param values The application security group specified as source.
     */
    @JvmName("ogvdcjgfhdwkhsuw")
    public suspend fun sourceApplicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("txshnstrftxkcxcw")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("hjyolqcsrfnpvyte")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("hyvknagmwlckjxal")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("rqmjhcaycxekaduk")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SecurityRuleArgs = SecurityRuleArgs(
        access = access ?: throw PulumiNullFieldException("access"),
        description = description,
        destinationAddressPrefix = destinationAddressPrefix,
        destinationAddressPrefixes = destinationAddressPrefixes,
        destinationApplicationSecurityGroups = destinationApplicationSecurityGroups,
        destinationPortRange = destinationPortRange,
        destinationPortRanges = destinationPortRanges,
        direction = direction ?: throw PulumiNullFieldException("direction"),
        etag = etag,
        id = id,
        name = name,
        priority = priority,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        provisioningState = provisioningState,
        sourceAddressPrefix = sourceAddressPrefix,
        sourceAddressPrefixes = sourceAddressPrefixes,
        sourceApplicationSecurityGroups = sourceApplicationSecurityGroups,
        sourcePortRange = sourcePortRange,
        sourcePortRanges = sourcePortRanges,
        type = type,
    )
}
