@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Service End point policy resource.
 * @property contextualServiceEndpointPolicies A collection of contextual service endpoint policy.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property serviceAlias The alias indicating if the policy belongs to a service
 * @property serviceEndpointPolicyDefinitions A collection of service endpoint policy definitions of the service endpoint policy.
 * @property tags Resource tags.
 */
public data class ServiceEndpointPolicyArgs(
    public val contextualServiceEndpointPolicies: Output<List<String>>? = null,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val serviceAlias: Output<String>? = null,
    public val serviceEndpointPolicyDefinitions: Output<List<ServiceEndpointPolicyDefinitionArgs>>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyArgs =
        com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyArgs.builder()
            .contextualServiceEndpointPolicies(
                contextualServiceEndpointPolicies?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .serviceAlias(serviceAlias?.applyValue({ args0 -> args0 }))
            .serviceEndpointPolicyDefinitions(
                serviceEndpointPolicyDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceEndpointPolicyArgs].
 */
@PulumiTagMarker
public class ServiceEndpointPolicyArgsBuilder internal constructor() {
    private var contextualServiceEndpointPolicies: Output<List<String>>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var serviceAlias: Output<String>? = null

    private var serviceEndpointPolicyDefinitions: Output<List<ServiceEndpointPolicyDefinitionArgs>>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A collection of contextual service endpoint policy.
     */
    @JvmName("rrupkssthdkqcfpp")
    public suspend fun contextualServiceEndpointPolicies(`value`: Output<List<String>>) {
        this.contextualServiceEndpointPolicies = value
    }

    @JvmName("lhlvocrtnxcxmuch")
    public suspend fun contextualServiceEndpointPolicies(vararg values: Output<String>) {
        this.contextualServiceEndpointPolicies = Output.all(values.asList())
    }

    /**
     * @param values A collection of contextual service endpoint policy.
     */
    @JvmName("eatxrhvanlarvdis")
    public suspend fun contextualServiceEndpointPolicies(values: List<Output<String>>) {
        this.contextualServiceEndpointPolicies = Output.all(values)
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("uhlmpwqxnpbuidkx")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("keqaguovouakymmx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("mrbtbwtvvrhxlnov")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The alias indicating if the policy belongs to a service
     */
    @JvmName("ctfsuvsrbjivtcfj")
    public suspend fun serviceAlias(`value`: Output<String>) {
        this.serviceAlias = value
    }

    /**
     * @param value A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("jnmwkyludquysojm")
    public suspend fun serviceEndpointPolicyDefinitions(`value`: Output<List<ServiceEndpointPolicyDefinitionArgs>>) {
        this.serviceEndpointPolicyDefinitions = value
    }

    @JvmName("yaqvisbihmaujjqj")
    public suspend fun serviceEndpointPolicyDefinitions(vararg values: Output<ServiceEndpointPolicyDefinitionArgs>) {
        this.serviceEndpointPolicyDefinitions = Output.all(values.asList())
    }

    /**
     * @param values A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("tccmlegqvkqawmfd")
    public suspend fun serviceEndpointPolicyDefinitions(values: List<Output<ServiceEndpointPolicyDefinitionArgs>>) {
        this.serviceEndpointPolicyDefinitions = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bjfjmoqxppptgpdm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A collection of contextual service endpoint policy.
     */
    @JvmName("wbaowijyxlibqgrc")
    public suspend fun contextualServiceEndpointPolicies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextualServiceEndpointPolicies = mapped
    }

    /**
     * @param values A collection of contextual service endpoint policy.
     */
    @JvmName("ckqeinbantmdcegv")
    public suspend fun contextualServiceEndpointPolicies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contextualServiceEndpointPolicies = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("wqwyuehilremosgt")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qedynxcisfbroyjj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lwnidgykiygfvory")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The alias indicating if the policy belongs to a service
     */
    @JvmName("exdjmdhbtdcveosf")
    public suspend fun serviceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAlias = mapped
    }

    /**
     * @param value A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("foqmoqiemyicxbam")
    public suspend fun serviceEndpointPolicyDefinitions(`value`: List<ServiceEndpointPolicyDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param argument A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("stskgppnhvveaxxq")
    public suspend fun serviceEndpointPolicyDefinitions(argument: List<suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param argument A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("ybpsmesqyeatuidc")
    public suspend fun serviceEndpointPolicyDefinitions(vararg argument: suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param argument A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("qgabhusjigxyvnow")
    public suspend fun serviceEndpointPolicyDefinitions(argument: suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceEndpointPolicyDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param values A collection of service endpoint policy definitions of the service endpoint policy.
     */
    @JvmName("rpvtrdacwkyrbojv")
    public suspend fun serviceEndpointPolicyDefinitions(vararg values: ServiceEndpointPolicyDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("emfwsndssbtolbgx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hsxowhcrcrtstejs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceEndpointPolicyArgs = ServiceEndpointPolicyArgs(
        contextualServiceEndpointPolicies = contextualServiceEndpointPolicies,
        etag = etag,
        id = id,
        location = location,
        serviceAlias = serviceAlias,
        serviceEndpointPolicyDefinitions = serviceEndpointPolicyDefinitions,
        tags = tags,
    )
}
