@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SubscriptionIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Subscription id in the ARM id format.
 */
public data class SubscriptionIdArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SubscriptionIdArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SubscriptionIdArgs =
        com.pulumi.azurenative.network.inputs.SubscriptionIdArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionIdArgs].
 */
@PulumiTagMarker
public class SubscriptionIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Subscription id in the ARM id format.
     */
    @JvmName("apnoardvoeenokkp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Subscription id in the ARM id format.
     */
    @JvmName("vqynakbyccrtgrdw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SubscriptionIdArgs = SubscriptionIdArgs(
        id = id,
    )
}
