@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.TrafficAnalyticsConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters that define the configuration of traffic analytics.
 * @property enabled Flag to enable/disable traffic analytics.
 * @property trafficAnalyticsInterval The interval in minutes which would decide how frequently TA service should do flow analytics.
 * @property workspaceId The resource guid of the attached workspace.
 * @property workspaceRegion The location of the attached workspace.
 * @property workspaceResourceId Resource Id of the attached workspace.
 */
public data class TrafficAnalyticsConfigurationPropertiesArgs(
    public val enabled: Output<Boolean>? = null,
    public val trafficAnalyticsInterval: Output<Int>? = null,
    public val workspaceId: Output<String>? = null,
    public val workspaceRegion: Output<String>? = null,
    public val workspaceResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.TrafficAnalyticsConfigurationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.TrafficAnalyticsConfigurationPropertiesArgs =
        com.pulumi.azurenative.network.inputs.TrafficAnalyticsConfigurationPropertiesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .trafficAnalyticsInterval(trafficAnalyticsInterval?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 }))
            .workspaceRegion(workspaceRegion?.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficAnalyticsConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class TrafficAnalyticsConfigurationPropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var trafficAnalyticsInterval: Output<Int>? = null

    private var workspaceId: Output<String>? = null

    private var workspaceRegion: Output<String>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value Flag to enable/disable traffic analytics.
     */
    @JvmName("gbrachfbsspnxquy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The interval in minutes which would decide how frequently TA service should do flow analytics.
     */
    @JvmName("rsqdwjiwvthwvvow")
    public suspend fun trafficAnalyticsInterval(`value`: Output<Int>) {
        this.trafficAnalyticsInterval = value
    }

    /**
     * @param value The resource guid of the attached workspace.
     */
    @JvmName("iflhvebkjvhtmkpd")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The location of the attached workspace.
     */
    @JvmName("nwmbpdqncirkxygk")
    public suspend fun workspaceRegion(`value`: Output<String>) {
        this.workspaceRegion = value
    }

    /**
     * @param value Resource Id of the attached workspace.
     */
    @JvmName("syhioquovshxwpne")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value Flag to enable/disable traffic analytics.
     */
    @JvmName("axrimxbqshukexll")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The interval in minutes which would decide how frequently TA service should do flow analytics.
     */
    @JvmName("wgueyxfwuemsyaho")
    public suspend fun trafficAnalyticsInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficAnalyticsInterval = mapped
    }

    /**
     * @param value The resource guid of the attached workspace.
     */
    @JvmName("umlkyvrtycaketcv")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    /**
     * @param value The location of the attached workspace.
     */
    @JvmName("aevclmxnlfhekcjp")
    public suspend fun workspaceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceRegion = mapped
    }

    /**
     * @param value Resource Id of the attached workspace.
     */
    @JvmName("xdwgswfasgijosxm")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): TrafficAnalyticsConfigurationPropertiesArgs =
        TrafficAnalyticsConfigurationPropertiesArgs(
            enabled = enabled,
            trafficAnalyticsInterval = trafficAnalyticsInterval,
            workspaceId = workspaceId,
            workspaceRegion = workspaceRegion,
            workspaceResourceId = workspaceResourceId,
        )
}
