@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.TrafficAnalyticsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Parameters that define the configuration of traffic analytics.
 * @property networkWatcherFlowAnalyticsConfiguration Parameters that define the configuration of traffic analytics.
 */
public data class TrafficAnalyticsPropertiesArgs(
    public val networkWatcherFlowAnalyticsConfiguration: Output<TrafficAnalyticsConfigurationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.TrafficAnalyticsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.TrafficAnalyticsPropertiesArgs =
        com.pulumi.azurenative.network.inputs.TrafficAnalyticsPropertiesArgs.builder()
            .networkWatcherFlowAnalyticsConfiguration(
                networkWatcherFlowAnalyticsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [TrafficAnalyticsPropertiesArgs].
 */
@PulumiTagMarker
public class TrafficAnalyticsPropertiesArgsBuilder internal constructor() {
    private var networkWatcherFlowAnalyticsConfiguration:
        Output<TrafficAnalyticsConfigurationPropertiesArgs>? = null

    /**
     * @param value Parameters that define the configuration of traffic analytics.
     */
    @JvmName("mqdigbybnldwhchl")
    public suspend fun networkWatcherFlowAnalyticsConfiguration(`value`: Output<TrafficAnalyticsConfigurationPropertiesArgs>) {
        this.networkWatcherFlowAnalyticsConfiguration = value
    }

    /**
     * @param value Parameters that define the configuration of traffic analytics.
     */
    @JvmName("lvyatblopyacxpkr")
    public suspend fun networkWatcherFlowAnalyticsConfiguration(`value`: TrafficAnalyticsConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkWatcherFlowAnalyticsConfiguration = mapped
    }

    /**
     * @param argument Parameters that define the configuration of traffic analytics.
     */
    @JvmName("gddmpytxotftvyyk")
    public suspend fun networkWatcherFlowAnalyticsConfiguration(argument: suspend TrafficAnalyticsConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TrafficAnalyticsConfigurationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkWatcherFlowAnalyticsConfiguration = mapped
    }

    internal fun build(): TrafficAnalyticsPropertiesArgs = TrafficAnalyticsPropertiesArgs(
        networkWatcherFlowAnalyticsConfiguration = networkWatcherFlowAnalyticsConfiguration,
    )
}
