@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VM.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine.
 * @property id Resource ID.
 * @property location Resource location.
 * @property tags Resource tags.
 */
public data class VM(
    public val id: String? = null,
    public val location: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VM> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VM =
        com.pulumi.azurenative.network.inputs.VM.builder()
            .id(id?.let({ args0 -> args0 }))
            .location(location?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [VM].
 */
@PulumiTagMarker
public class VMBuilder internal constructor() {
    private var id: String? = null

    private var location: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("axusesrffijggexv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dsacjgwvbnxebyne")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jgugxbydsumpwgbk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ynnitcwssjhgerwa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): VM = VM(
        id = id,
        location = location,
        tags = tags,
    )
}
