@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualHubRouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualHub route table.
 * @property routes List of all routes.
 */
public data class VirtualHubRouteTableArgs(
    public val routes: Output<List<VirtualHubRouteArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualHubRouteTableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualHubRouteTableArgs =
        com.pulumi.azurenative.network.inputs.VirtualHubRouteTableArgs.builder()
            .routes(
                routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualHubRouteTableArgs].
 */
@PulumiTagMarker
public class VirtualHubRouteTableArgsBuilder internal constructor() {
    private var routes: Output<List<VirtualHubRouteArgs>>? = null

    /**
     * @param value List of all routes.
     */
    @JvmName("ydcslfkjmidtqdxv")
    public suspend fun routes(`value`: Output<List<VirtualHubRouteArgs>>) {
        this.routes = value
    }

    @JvmName("anpgdwugwampdpvl")
    public suspend fun routes(vararg values: Output<VirtualHubRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("bwxwdcttpkrcsbey")
    public suspend fun routes(values: List<Output<VirtualHubRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("pkmiyulklkkgigmc")
    public suspend fun routes(`value`: List<VirtualHubRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("ggttyebqkxlhnmck")
    public suspend fun routes(argument: List<suspend VirtualHubRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("kybykjxqqlhswggu")
    public suspend fun routes(vararg argument: suspend VirtualHubRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("utobqlsarlibpknw")
    public suspend fun routes(argument: suspend VirtualHubRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualHubRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("evvmgyqllpdwihfn")
    public suspend fun routes(vararg values: VirtualHubRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): VirtualHubRouteTableArgs = VirtualHubRouteTableArgs(
        routes = routes,
    )
}
