@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkEncryptionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkEncryptionEnforcement
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
 * @property enabled Indicates if encryption is enabled on the virtual network.
 * @property enforcement If the encrypted VNet allows VM that does not support encryption
 */
public data class VirtualNetworkEncryptionArgs(
    public val enabled: Output<Boolean>,
    public val enforcement: Output<Either<String, VirtualNetworkEncryptionEnforcement>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkEncryptionArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkEncryptionArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .enforcement(
                enforcement?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkEncryptionArgs].
 */
@PulumiTagMarker
public class VirtualNetworkEncryptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var enforcement: Output<Either<String, VirtualNetworkEncryptionEnforcement>>? = null

    /**
     * @param value Indicates if encryption is enabled on the virtual network.
     */
    @JvmName("gfruwlmimqceaomv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value If the encrypted VNet allows VM that does not support encryption
     */
    @JvmName("pgnehjaqrxavwals")
    public suspend fun enforcement(`value`: Output<Either<String, VirtualNetworkEncryptionEnforcement>>) {
        this.enforcement = value
    }

    /**
     * @param value Indicates if encryption is enabled on the virtual network.
     */
    @JvmName("crbhooreokxvskru")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value If the encrypted VNet allows VM that does not support encryption
     */
    @JvmName("ysgaysbofhfsomkt")
    public suspend fun enforcement(`value`: Either<String, VirtualNetworkEncryptionEnforcement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcement = mapped
    }

    /**
     * @param value If the encrypted VNet allows VM that does not support encryption
     */
    @JvmName("ybonwugvgirihujj")
    public fun enforcement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkEncryptionEnforcement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforcement = mapped
    }

    /**
     * @param value If the encrypted VNet allows VM that does not support encryption
     */
    @JvmName("wkjevsjurriwabck")
    public fun enforcement(`value`: VirtualNetworkEncryptionEnforcement) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkEncryptionEnforcement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforcement = mapped
    }

    internal fun build(): VirtualNetworkEncryptionArgs = VirtualNetworkEncryptionArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        enforcement = enforcement,
    )
}
