@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters for VirtualNetworkGatewayPolicyGroup.
 * @property id Resource ID.
 * @property isDefault Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property policyMembers Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
 * @property priority Priority for VirtualNetworkGatewayPolicyGroup.
 */
public data class VirtualNetworkGatewayPolicyGroupArgs(
    public val id: Output<String>? = null,
    public val isDefault: Output<Boolean>,
    public val name: Output<String>? = null,
    public val policyMembers: Output<List<VirtualNetworkGatewayPolicyGroupMemberArgs>>,
    public val priority: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupArgs = com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupArgs.builder()
        .id(id?.applyValue({ args0 -> args0 }))
        .isDefault(isDefault.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .policyMembers(
            policyMembers.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .priority(priority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkGatewayPolicyGroupArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayPolicyGroupArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var isDefault: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var policyMembers: Output<List<VirtualNetworkGatewayPolicyGroupMemberArgs>>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("tskdfobsmdyxbvdv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
     */
    @JvmName("rbpxppdmixqfethc")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("adknpotkhbfllbpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("nwuujngukhnigfwb")
    public suspend fun policyMembers(`value`: Output<List<VirtualNetworkGatewayPolicyGroupMemberArgs>>) {
        this.policyMembers = value
    }

    @JvmName("etdvpsxmbnuqbrdt")
    public suspend fun policyMembers(vararg values: Output<VirtualNetworkGatewayPolicyGroupMemberArgs>) {
        this.policyMembers = Output.all(values.asList())
    }

    /**
     * @param values Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("xegpxiofebhlyamc")
    public suspend fun policyMembers(values: List<Output<VirtualNetworkGatewayPolicyGroupMemberArgs>>) {
        this.policyMembers = Output.all(values)
    }

    /**
     * @param value Priority for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("rswudsyxhllarabq")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("uvinubyfxcrqvssb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
     */
    @JvmName("wkkauhaprpaywnpj")
    public suspend fun isDefault(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("tjngfegrtnwshaij")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("derlamtqyxvdqgbg")
    public suspend fun policyMembers(`value`: List<VirtualNetworkGatewayPolicyGroupMemberArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("jtkpogsymqbjybev")
    public suspend fun policyMembers(argument: List<suspend VirtualNetworkGatewayPolicyGroupMemberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayPolicyGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("nwghckxuluvywqtk")
    public suspend fun policyMembers(vararg argument: suspend VirtualNetworkGatewayPolicyGroupMemberArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayPolicyGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("ulaxdgbvsqxiwbae")
    public suspend fun policyMembers(argument: suspend VirtualNetworkGatewayPolicyGroupMemberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayPolicyGroupMemberArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param values Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("oalvtgonevexrnep")
    public suspend fun policyMembers(vararg values: VirtualNetworkGatewayPolicyGroupMemberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyMembers = mapped
    }

    /**
     * @param value Priority for VirtualNetworkGatewayPolicyGroup.
     */
    @JvmName("bdiitkfqkhaftgne")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): VirtualNetworkGatewayPolicyGroupArgs = VirtualNetworkGatewayPolicyGroupArgs(
        id = id,
        isDefault = isDefault ?: throw PulumiNullFieldException("isDefault"),
        name = name,
        policyMembers = policyMembers ?: throw PulumiNullFieldException("policyMembers"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
