@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewaySkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewaySkuName
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewaySkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VirtualNetworkGatewaySku details.
 * @property name Gateway SKU name.
 * @property tier Gateway SKU tier.
 */
public data class VirtualNetworkGatewaySkuArgs(
    public val name: Output<Either<String, VirtualNetworkGatewaySkuName>>? = null,
    public val tier: Output<Either<String, VirtualNetworkGatewaySkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkGatewaySkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkGatewaySkuArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewaySkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkGatewaySkuArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewaySkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, VirtualNetworkGatewaySkuName>>? = null

    private var tier: Output<Either<String, VirtualNetworkGatewaySkuTier>>? = null

    /**
     * @param value Gateway SKU name.
     */
    @JvmName("blqosmmugstxaopj")
    public suspend fun name(`value`: Output<Either<String, VirtualNetworkGatewaySkuName>>) {
        this.name = value
    }

    /**
     * @param value Gateway SKU tier.
     */
    @JvmName("msuypmbgdqhrqqsh")
    public suspend fun tier(`value`: Output<Either<String, VirtualNetworkGatewaySkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Gateway SKU name.
     */
    @JvmName("siojahaurwfmsodt")
    public suspend fun name(`value`: Either<String, VirtualNetworkGatewaySkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gateway SKU name.
     */
    @JvmName("kvjgsqhmaparsqne")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewaySkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gateway SKU name.
     */
    @JvmName("dtjsegoendffygsk")
    public fun name(`value`: VirtualNetworkGatewaySkuName) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewaySkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gateway SKU tier.
     */
    @JvmName("fgntwdiuuqkypbvp")
    public suspend fun tier(`value`: Either<String, VirtualNetworkGatewaySkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Gateway SKU tier.
     */
    @JvmName("hrhxrtceubacyxid")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewaySkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Gateway SKU tier.
     */
    @JvmName("ykeweabawesfevov")
    public fun tier(`value`: VirtualNetworkGatewaySkuTier) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewaySkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): VirtualNetworkGatewaySkuArgs = VirtualNetworkGatewaySkuArgs(
        name = name,
        tier = tier,
    )
}
