@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VnetRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * List of routes that control routing from VirtualHub into a virtual network connection.
 * @property staticRoutes List of all Static Routes.
 * @property staticRoutesConfig Configuration for static routes on this HubVnetConnection.
 */
public data class VnetRouteArgs(
    public val staticRoutes: Output<List<StaticRouteArgs>>? = null,
    public val staticRoutesConfig: Output<StaticRoutesConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VnetRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VnetRouteArgs =
        com.pulumi.azurenative.network.inputs.VnetRouteArgs.builder()
            .staticRoutes(
                staticRoutes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .staticRoutesConfig(
                staticRoutesConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VnetRouteArgs].
 */
@PulumiTagMarker
public class VnetRouteArgsBuilder internal constructor() {
    private var staticRoutes: Output<List<StaticRouteArgs>>? = null

    private var staticRoutesConfig: Output<StaticRoutesConfigArgs>? = null

    /**
     * @param value List of all Static Routes.
     */
    @JvmName("wegslvmautrcivrn")
    public suspend fun staticRoutes(`value`: Output<List<StaticRouteArgs>>) {
        this.staticRoutes = value
    }

    @JvmName("roqyupdhyklssuja")
    public suspend fun staticRoutes(vararg values: Output<StaticRouteArgs>) {
        this.staticRoutes = Output.all(values.asList())
    }

    /**
     * @param values List of all Static Routes.
     */
    @JvmName("yjeimpvkcrgyinxx")
    public suspend fun staticRoutes(values: List<Output<StaticRouteArgs>>) {
        this.staticRoutes = Output.all(values)
    }

    /**
     * @param value Configuration for static routes on this HubVnetConnection.
     */
    @JvmName("yrudyfdmftufxsdh")
    public suspend fun staticRoutesConfig(`value`: Output<StaticRoutesConfigArgs>) {
        this.staticRoutesConfig = value
    }

    /**
     * @param value List of all Static Routes.
     */
    @JvmName("fliafpfuklnxadvq")
    public suspend fun staticRoutes(`value`: List<StaticRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticRoutes = mapped
    }

    /**
     * @param argument List of all Static Routes.
     */
    @JvmName("vkuisrmgpcsdhhit")
    public suspend fun staticRoutes(argument: List<suspend StaticRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { StaticRouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.staticRoutes = mapped
    }

    /**
     * @param argument List of all Static Routes.
     */
    @JvmName("hsqsrvtrwrhfipuw")
    public suspend fun staticRoutes(vararg argument: suspend StaticRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { StaticRouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.staticRoutes = mapped
    }

    /**
     * @param argument List of all Static Routes.
     */
    @JvmName("otemvmplsnvmjgqx")
    public suspend fun staticRoutes(argument: suspend StaticRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StaticRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.staticRoutes = mapped
    }

    /**
     * @param values List of all Static Routes.
     */
    @JvmName("gikdaunnkrpbycsr")
    public suspend fun staticRoutes(vararg values: StaticRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticRoutes = mapped
    }

    /**
     * @param value Configuration for static routes on this HubVnetConnection.
     */
    @JvmName("qsgkomprdneupfxg")
    public suspend fun staticRoutesConfig(`value`: StaticRoutesConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticRoutesConfig = mapped
    }

    /**
     * @param argument Configuration for static routes on this HubVnetConnection.
     */
    @JvmName("mwjbdlyqjcvgjowb")
    public suspend fun staticRoutesConfig(argument: suspend StaticRoutesConfigArgsBuilder.() -> Unit) {
        val toBeMapped = StaticRoutesConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.staticRoutesConfig = mapped
    }

    internal fun build(): VnetRouteArgs = VnetRouteArgs(
        staticRoutes = staticRoutes,
        staticRoutesConfig = staticRoutesConfig,
    )
}
