@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnAuthenticationType
import com.pulumi.azurenative.network.kotlin.enums.VpnClientProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnClientConfiguration for P2S client.
 * @property aadAudience The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadIssuer The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadTenant The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property radiusServerAddress The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServerSecret The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServers The radiusServers property for multiple radius server configuration.
 * @property vngClientConnectionConfigurations per ip address pool connection policy for virtual network gateway P2S client.
 * @property vpnAuthenticationTypes VPN authentication types for the virtual network gateway..
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for virtual network gateway P2S client.
 * @property vpnClientProtocols VpnClientProtocols for Virtual network gateway.
 * @property vpnClientRevokedCertificates VpnClientRevokedCertificate for Virtual network gateway.
 * @property vpnClientRootCertificates VpnClientRootCertificate for virtual network gateway.
 */
public data class VpnClientConfigurationArgs(
    public val aadAudience: Output<String>? = null,
    public val aadIssuer: Output<String>? = null,
    public val aadTenant: Output<String>? = null,
    public val radiusServerAddress: Output<String>? = null,
    public val radiusServerSecret: Output<String>? = null,
    public val radiusServers: Output<List<RadiusServerArgs>>? = null,
    public val vngClientConnectionConfigurations: Output<List<VngClientConnectionConfigurationArgs>>? =
        null,
    public val vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null,
    public val vpnClientAddressPool: Output<AddressSpaceArgs>? = null,
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val vpnClientProtocols: Output<List<Either<String, VpnClientProtocol>>>? = null,
    public val vpnClientRevokedCertificates: Output<List<VpnClientRevokedCertificateArgs>>? = null,
    public val vpnClientRootCertificates: Output<List<VpnClientRootCertificateArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs =
        com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs.builder()
            .aadAudience(aadAudience?.applyValue({ args0 -> args0 }))
            .aadIssuer(aadIssuer?.applyValue({ args0 -> args0 }))
            .aadTenant(aadTenant?.applyValue({ args0 -> args0 }))
            .radiusServerAddress(radiusServerAddress?.applyValue({ args0 -> args0 }))
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 }))
            .radiusServers(
                radiusServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vngClientConnectionConfigurations(
                vngClientConnectionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnAuthenticationTypes(
                vpnAuthenticationTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientAddressPool(
                vpnClientAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpnClientIpsecPolicies(
                vpnClientIpsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnClientProtocols(
                vpnClientProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientRevokedCertificates(
                vpnClientRevokedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientRootCertificates(
                vpnClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnClientConfigurationArgs].
 */
@PulumiTagMarker
public class VpnClientConfigurationArgsBuilder internal constructor() {
    private var aadAudience: Output<String>? = null

    private var aadIssuer: Output<String>? = null

    private var aadTenant: Output<String>? = null

    private var radiusServerAddress: Output<String>? = null

    private var radiusServerSecret: Output<String>? = null

    private var radiusServers: Output<List<RadiusServerArgs>>? = null

    private var vngClientConnectionConfigurations: Output<List<VngClientConnectionConfigurationArgs>>? =
        null

    private var vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null

    private var vpnClientAddressPool: Output<AddressSpaceArgs>? = null

    private var vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var vpnClientProtocols: Output<List<Either<String, VpnClientProtocol>>>? = null

    private var vpnClientRevokedCertificates: Output<List<VpnClientRevokedCertificateArgs>>? = null

    private var vpnClientRootCertificates: Output<List<VpnClientRootCertificateArgs>>? = null

    /**
     * @param value The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("kcgklmgrdtsicktt")
    public suspend fun aadAudience(`value`: Output<String>) {
        this.aadAudience = value
    }

    /**
     * @param value The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("paualbflvqhvgvrw")
    public suspend fun aadIssuer(`value`: Output<String>) {
        this.aadIssuer = value
    }

    /**
     * @param value The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("prknomolkpihlpcv")
    public suspend fun aadTenant(`value`: Output<String>) {
        this.aadTenant = value
    }

    /**
     * @param value The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("vpkhsuduwfdaeblg")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("uexuxoqpicihpdfq")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value The radiusServers property for multiple radius server configuration.
     */
    @JvmName("wmvbvtkrghcfvpaq")
    public suspend fun radiusServers(`value`: Output<List<RadiusServerArgs>>) {
        this.radiusServers = value
    }

    @JvmName("rimigndhyrukgnhl")
    public suspend fun radiusServers(vararg values: Output<RadiusServerArgs>) {
        this.radiusServers = Output.all(values.asList())
    }

    /**
     * @param values The radiusServers property for multiple radius server configuration.
     */
    @JvmName("rgoyhnlthxenawik")
    public suspend fun radiusServers(values: List<Output<RadiusServerArgs>>) {
        this.radiusServers = Output.all(values)
    }

    /**
     * @param value per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("tcdxsguiaotdumca")
    public suspend fun vngClientConnectionConfigurations(`value`: Output<List<VngClientConnectionConfigurationArgs>>) {
        this.vngClientConnectionConfigurations = value
    }

    @JvmName("pggombollmkuhqcc")
    public suspend fun vngClientConnectionConfigurations(vararg values: Output<VngClientConnectionConfigurationArgs>) {
        this.vngClientConnectionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("obsygmiqqkclnnsd")
    public suspend fun vngClientConnectionConfigurations(values: List<Output<VngClientConnectionConfigurationArgs>>) {
        this.vngClientConnectionConfigurations = Output.all(values)
    }

    /**
     * @param value VPN authentication types for the virtual network gateway..
     */
    @JvmName("cwlaaweuwyeadpwq")
    public suspend fun vpnAuthenticationTypes(`value`: Output<List<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = value
    }

    @JvmName("pefokhbbdbgecccc")
    public suspend fun vpnAuthenticationTypes(vararg values: Output<Either<String, VpnAuthenticationType>>) {
        this.vpnAuthenticationTypes = Output.all(values.asList())
    }

    /**
     * @param values VPN authentication types for the virtual network gateway..
     */
    @JvmName("cffgfvkcwyacfxch")
    public suspend fun vpnAuthenticationTypes(values: List<Output<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = Output.all(values)
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("dojkeudkelxybgrx")
    public suspend fun vpnClientAddressPool(`value`: Output<AddressSpaceArgs>) {
        this.vpnClientAddressPool = value
    }

    /**
     * @param value VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("oftccjvvthjsyiks")
    public suspend fun vpnClientIpsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = value
    }

    @JvmName("mjsxhdinjmolhtgu")
    public suspend fun vpnClientIpsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.vpnClientIpsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("gdcvsuylgivsunqa")
    public suspend fun vpnClientIpsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = Output.all(values)
    }

    /**
     * @param value VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("qligpfwlxmljibie")
    public suspend fun vpnClientProtocols(`value`: Output<List<Either<String, VpnClientProtocol>>>) {
        this.vpnClientProtocols = value
    }

    @JvmName("kxvduolweqmcxnue")
    public suspend fun vpnClientProtocols(vararg values: Output<Either<String, VpnClientProtocol>>) {
        this.vpnClientProtocols = Output.all(values.asList())
    }

    /**
     * @param values VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("xmipaxntqirwayjj")
    public suspend fun vpnClientProtocols(values: List<Output<Either<String, VpnClientProtocol>>>) {
        this.vpnClientProtocols = Output.all(values)
    }

    /**
     * @param value VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("xvercwpdalfdcvhy")
    public suspend fun vpnClientRevokedCertificates(`value`: Output<List<VpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = value
    }

    @JvmName("mwfmgoxchdhdabaf")
    public suspend fun vpnClientRevokedCertificates(vararg values: Output<VpnClientRevokedCertificateArgs>) {
        this.vpnClientRevokedCertificates = Output.all(values.asList())
    }

    /**
     * @param values VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("dksbkuygqedwnkup")
    public suspend fun vpnClientRevokedCertificates(values: List<Output<VpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = Output.all(values)
    }

    /**
     * @param value VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("fjqmcosdtdblunlm")
    public suspend fun vpnClientRootCertificates(`value`: Output<List<VpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = value
    }

    @JvmName("hntqxvfckqhyxrpt")
    public suspend fun vpnClientRootCertificates(vararg values: Output<VpnClientRootCertificateArgs>) {
        this.vpnClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("lgpjlqhxqaodpbaq")
    public suspend fun vpnClientRootCertificates(values: List<Output<VpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = Output.all(values)
    }

    /**
     * @param value The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("ximmtktwabtgfjns")
    public suspend fun aadAudience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAudience = mapped
    }

    /**
     * @param value The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("dsvuitdqubyeakww")
    public suspend fun aadIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadIssuer = mapped
    }

    /**
     * @param value The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("qqjfkfuytjydhyhg")
    public suspend fun aadTenant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenant = mapped
    }

    /**
     * @param value The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("vhsnsnfvllsqrndp")
    public suspend fun radiusServerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("waurfhkobfvfoebe")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    /**
     * @param value The radiusServers property for multiple radius server configuration.
     */
    @JvmName("hikwxareqnrkxuqi")
    public suspend fun radiusServers(`value`: List<RadiusServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("xqemfljnpwageoxb")
    public suspend fun radiusServers(argument: List<suspend RadiusServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("srehsqarqjimrlmg")
    public suspend fun radiusServers(vararg argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("olvmcowxuqstqkbh")
    public suspend fun radiusServers(argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RadiusServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param values The radiusServers property for multiple radius server configuration.
     */
    @JvmName("psnmujmergfdgngh")
    public suspend fun radiusServers(vararg values: RadiusServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param value per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("rsfikbojhdxhcfhb")
    public suspend fun vngClientConnectionConfigurations(`value`: List<VngClientConnectionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("frkbtocmweokqkaj")
    public suspend fun vngClientConnectionConfigurations(argument: List<suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VngClientConnectionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("smqcghfhkceofair")
    public suspend fun vngClientConnectionConfigurations(vararg argument: suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VngClientConnectionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("huoecvvwnanexfdd")
    public suspend fun vngClientConnectionConfigurations(argument: suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VngClientConnectionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param values per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("wcfixsfavdseyrqr")
    public suspend fun vngClientConnectionConfigurations(vararg values: VngClientConnectionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param value VPN authentication types for the virtual network gateway..
     */
    @JvmName("lljttlkyhghxdlmn")
    public suspend fun vpnAuthenticationTypes(`value`: List<Either<String, VpnAuthenticationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param values VPN authentication types for the virtual network gateway..
     */
    @JvmName("vsogyjaogpyyhjhd")
    public suspend fun vpnAuthenticationTypes(vararg values: Either<String, VpnAuthenticationType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("addyrrabnsfsvtti")
    public suspend fun vpnClientAddressPool(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("vufdikgfltyflfam")
    public suspend fun vpnClientAddressPool(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param value VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("xcybalhrxdmvhkla")
    public suspend fun vpnClientIpsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("mjepaekaaliygrti")
    public suspend fun vpnClientIpsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("mwgonvrkiwyxigva")
    public suspend fun vpnClientIpsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("wodqstkgbaissgwk")
    public suspend fun vpnClientIpsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param values VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("pnwblprxlxagvbgs")
    public suspend fun vpnClientIpsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param value VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("npitqajrxfbkqusm")
    public suspend fun vpnClientProtocols(`value`: List<Either<String, VpnClientProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientProtocols = mapped
    }

    /**
     * @param values VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("leogwnioiybqlpyo")
    public suspend fun vpnClientProtocols(vararg values: Either<String, VpnClientProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientProtocols = mapped
    }

    /**
     * @param value VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("hloadnhonvgdadti")
    public suspend fun vpnClientRevokedCertificates(`value`: List<VpnClientRevokedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("kxrmifwgdhloggrd")
    public suspend fun vpnClientRevokedCertificates(argument: List<suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("dfvxuiktpbjndwum")
    public suspend fun vpnClientRevokedCertificates(vararg argument: suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("qeujebyrgawdalfw")
    public suspend fun vpnClientRevokedCertificates(argument: suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param values VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("hdimviswinktiocd")
    public suspend fun vpnClientRevokedCertificates(vararg values: VpnClientRevokedCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param value VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("spjhskbenkcvxqhi")
    public suspend fun vpnClientRootCertificates(`value`: List<VpnClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("aiqhjcgjvgxfhgpj")
    public suspend fun vpnClientRootCertificates(argument: List<suspend VpnClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnClientRootCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("vdlnexokogvinrxu")
    public suspend fun vpnClientRootCertificates(vararg argument: suspend VpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnClientRootCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("pahowgyhqvteutqn")
    public suspend fun vpnClientRootCertificates(argument: suspend VpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param values VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("noenglkvsxkhpmuu")
    public suspend fun vpnClientRootCertificates(vararg values: VpnClientRootCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    internal fun build(): VpnClientConfigurationArgs = VpnClientConfigurationArgs(
        aadAudience = aadAudience,
        aadIssuer = aadIssuer,
        aadTenant = aadTenant,
        radiusServerAddress = radiusServerAddress,
        radiusServerSecret = radiusServerSecret,
        radiusServers = radiusServers,
        vngClientConnectionConfigurations = vngClientConnectionConfigurations,
        vpnAuthenticationTypes = vpnAuthenticationTypes,
        vpnClientAddressPool = vpnClientAddressPool,
        vpnClientIpsecPolicies = vpnClientIpsecPolicies,
        vpnClientProtocols = vpnClientProtocols,
        vpnClientRevokedCertificates = vpnClientRevokedCertificates,
        vpnClientRootCertificates = vpnClientRootCertificates,
    )
}
