@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnConnection Resource.
 * @property connectionBandwidth Expected bandwidth in MBPS.
 * @property dpdTimeoutSeconds DPD timeout in seconds for vpn connection.
 * @property enableBgp EnableBgp flag.
 * @property enableInternetSecurity Enable internet security.
 * @property enableRateLimiting EnableBgp flag.
 * @property id Resource ID.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property remoteVpnSite Id of the connected vpn site.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property routingWeight Routing weight for vpn connection.
 * @property sharedKey SharedKey for the vpn connection.
 * @property trafficSelectorPolicies The Traffic Selector Policies to be considered by this connection.
 * @property useLocalAzureIpAddress Use local azure ip to initiate connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property vpnConnectionProtocolType Connection protocol used for this connection.
 * @property vpnLinkConnections List of all vpn site link connections to the gateway.
 */
public data class VpnConnectionArgs(
    public val connectionBandwidth: Output<Int>? = null,
    public val dpdTimeoutSeconds: Output<Int>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enableInternetSecurity: Output<Boolean>? = null,
    public val enableRateLimiting: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val name: Output<String>? = null,
    public val remoteVpnSite: Output<SubResourceArgs>? = null,
    public val routingConfiguration: Output<RoutingConfigurationArgs>? = null,
    public val routingWeight: Output<Int>? = null,
    public val sharedKey: Output<String>? = null,
    public val trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null,
    public val useLocalAzureIpAddress: Output<Boolean>? = null,
    public val usePolicyBasedTrafficSelectors: Output<Boolean>? = null,
    public val vpnConnectionProtocolType: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? = null,
    public val vpnLinkConnections: Output<List<VpnSiteLinkConnectionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnConnectionArgs =
        com.pulumi.azurenative.network.inputs.VpnConnectionArgs.builder()
            .connectionBandwidth(connectionBandwidth?.applyValue({ args0 -> args0 }))
            .dpdTimeoutSeconds(dpdTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enableInternetSecurity(enableInternetSecurity?.applyValue({ args0 -> args0 }))
            .enableRateLimiting(enableRateLimiting?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipsecPolicies(
                ipsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .remoteVpnSite(remoteVpnSite?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .routingConfiguration(
                routingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .trafficSelectorPolicies(
                trafficSelectorPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .useLocalAzureIpAddress(useLocalAzureIpAddress?.applyValue({ args0 -> args0 }))
            .usePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors?.applyValue({ args0 -> args0 }))
            .vpnConnectionProtocolType(
                vpnConnectionProtocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnLinkConnections(
                vpnLinkConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnConnectionArgs].
 */
@PulumiTagMarker
public class VpnConnectionArgsBuilder internal constructor() {
    private var connectionBandwidth: Output<Int>? = null

    private var dpdTimeoutSeconds: Output<Int>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enableInternetSecurity: Output<Boolean>? = null

    private var enableRateLimiting: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var name: Output<String>? = null

    private var remoteVpnSite: Output<SubResourceArgs>? = null

    private var routingConfiguration: Output<RoutingConfigurationArgs>? = null

    private var routingWeight: Output<Int>? = null

    private var sharedKey: Output<String>? = null

    private var trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null

    private var useLocalAzureIpAddress: Output<Boolean>? = null

    private var usePolicyBasedTrafficSelectors: Output<Boolean>? = null

    private var vpnConnectionProtocolType:
        Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? = null

    private var vpnLinkConnections: Output<List<VpnSiteLinkConnectionArgs>>? = null

    /**
     * @param value Expected bandwidth in MBPS.
     */
    @JvmName("lhfwphvoojkvkasc")
    public suspend fun connectionBandwidth(`value`: Output<Int>) {
        this.connectionBandwidth = value
    }

    /**
     * @param value DPD timeout in seconds for vpn connection.
     */
    @JvmName("milhdwtbtyptjvtw")
    public suspend fun dpdTimeoutSeconds(`value`: Output<Int>) {
        this.dpdTimeoutSeconds = value
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("tyecxaownypcxomn")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("wbppwuxsfitqtuvc")
    public suspend fun enableInternetSecurity(`value`: Output<Boolean>) {
        this.enableInternetSecurity = value
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("yohyfgtjjlosftfr")
    public suspend fun enableRateLimiting(`value`: Output<Boolean>) {
        this.enableRateLimiting = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mdfxolgiapejqyxk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("ibumdhoickboxabe")
    public suspend fun ipsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.ipsecPolicies = value
    }

    @JvmName("rwifulqxttewpvcu")
    public suspend fun ipsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.ipsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("dnsxeowakqlvqrtu")
    public suspend fun ipsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.ipsecPolicies = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("mwkdsayinlwldqcx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Id of the connected vpn site.
     */
    @JvmName("vbyocohoacjekcrg")
    public suspend fun remoteVpnSite(`value`: Output<SubResourceArgs>) {
        this.remoteVpnSite = value
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("vrlvnvmfniwnodlj")
    public suspend fun routingConfiguration(`value`: Output<RoutingConfigurationArgs>) {
        this.routingConfiguration = value
    }

    /**
     * @param value Routing weight for vpn connection.
     */
    @JvmName("xlvtwkquphsumgiv")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value SharedKey for the vpn connection.
     */
    @JvmName("datndahhojflaltk")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("upuixybhgehiyaoc")
    public suspend fun trafficSelectorPolicies(`value`: Output<List<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = value
    }

    @JvmName("hfnrihctcjxlcuux")
    public suspend fun trafficSelectorPolicies(vararg values: Output<TrafficSelectorPolicyArgs>) {
        this.trafficSelectorPolicies = Output.all(values.asList())
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("toiddqacichnwabl")
    public suspend fun trafficSelectorPolicies(values: List<Output<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = Output.all(values)
    }

    /**
     * @param value Use local azure ip to initiate connection.
     */
    @JvmName("vjffapielhgyhysw")
    public suspend fun useLocalAzureIpAddress(`value`: Output<Boolean>) {
        this.useLocalAzureIpAddress = value
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("ddroxrolpegdygec")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Output<Boolean>) {
        this.usePolicyBasedTrafficSelectors = value
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("vatjudabdjuvtwyq")
    public suspend fun vpnConnectionProtocolType(`value`: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>) {
        this.vpnConnectionProtocolType = value
    }

    /**
     * @param value List of all vpn site link connections to the gateway.
     */
    @JvmName("spgnykqripnbdavo")
    public suspend fun vpnLinkConnections(`value`: Output<List<VpnSiteLinkConnectionArgs>>) {
        this.vpnLinkConnections = value
    }

    @JvmName("skifvnypbpedqeky")
    public suspend fun vpnLinkConnections(vararg values: Output<VpnSiteLinkConnectionArgs>) {
        this.vpnLinkConnections = Output.all(values.asList())
    }

    /**
     * @param values List of all vpn site link connections to the gateway.
     */
    @JvmName("yxnsrvgwcraudwvo")
    public suspend fun vpnLinkConnections(values: List<Output<VpnSiteLinkConnectionArgs>>) {
        this.vpnLinkConnections = Output.all(values)
    }

    /**
     * @param value Expected bandwidth in MBPS.
     */
    @JvmName("scvdxnpxxcmkmito")
    public suspend fun connectionBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionBandwidth = mapped
    }

    /**
     * @param value DPD timeout in seconds for vpn connection.
     */
    @JvmName("iwroghauypshbjuy")
    public suspend fun dpdTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dpdTimeoutSeconds = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("dsnmubcsnretpagg")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("qhghsrauyjnoxxig")
    public suspend fun enableInternetSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetSecurity = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("iqyefofdypdhiybu")
    public suspend fun enableRateLimiting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRateLimiting = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xfepnnkjvprsdcan")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("esowlojvtitfjxgr")
    public suspend fun ipsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("ukwpehgrpduxdaxt")
    public suspend fun ipsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("dfswcwnaeepuariu")
    public suspend fun ipsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("evnuxgnqdyelqsip")
    public suspend fun ipsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("iglfywownyoohhta")
    public suspend fun ipsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("sebbtfadaesupaup")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Id of the connected vpn site.
     */
    @JvmName("qpamwtrruucssjfh")
    public suspend fun remoteVpnSite(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVpnSite = mapped
    }

    /**
     * @param argument Id of the connected vpn site.
     */
    @JvmName("hjllnjfscomcavxh")
    public suspend fun remoteVpnSite(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVpnSite = mapped
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("cicyulfkmsksheen")
    public suspend fun routingConfiguration(`value`: RoutingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfiguration = mapped
    }

    /**
     * @param argument The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("ijsgapveemrjktax")
    public suspend fun routingConfiguration(argument: suspend RoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfiguration = mapped
    }

    /**
     * @param value Routing weight for vpn connection.
     */
    @JvmName("jbosvnvwwmfbvrfg")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    /**
     * @param value SharedKey for the vpn connection.
     */
    @JvmName("wnvqxgrrdsbvkbxq")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("orljyuyomalkvfaa")
    public suspend fun trafficSelectorPolicies(`value`: List<TrafficSelectorPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("ajeqsctccqpddhmx")
    public suspend fun trafficSelectorPolicies(argument: List<suspend TrafficSelectorPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("xnxhbtpvufxbuvcr")
    public suspend fun trafficSelectorPolicies(vararg argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("eugbixvmcutdulpr")
    public suspend fun trafficSelectorPolicies(argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrafficSelectorPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("adaomeqktbexwhkm")
    public suspend fun trafficSelectorPolicies(vararg values: TrafficSelectorPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param value Use local azure ip to initiate connection.
     */
    @JvmName("tydkqovinulhtqut")
    public suspend fun useLocalAzureIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLocalAzureIpAddress = mapped
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("bmpdrypubtahlofe")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePolicyBasedTrafficSelectors = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("okbsrpbfadbegxyg")
    public suspend fun vpnConnectionProtocolType(`value`: Either<String, VirtualNetworkGatewayConnectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("iukfjtmlyqpyvglt")
    public fun vpnConnectionProtocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("porjnhoohmajbepx")
    public fun vpnConnectionProtocolType(`value`: VirtualNetworkGatewayConnectionProtocol) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value List of all vpn site link connections to the gateway.
     */
    @JvmName("sthklcjbrlqgrfgg")
    public suspend fun vpnLinkConnections(`value`: List<VpnSiteLinkConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnLinkConnections = mapped
    }

    /**
     * @param argument List of all vpn site link connections to the gateway.
     */
    @JvmName("ufuelduwowgrhuyx")
    public suspend fun vpnLinkConnections(argument: List<suspend VpnSiteLinkConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnSiteLinkConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnLinkConnections = mapped
    }

    /**
     * @param argument List of all vpn site link connections to the gateway.
     */
    @JvmName("cvchooeiosirnprl")
    public suspend fun vpnLinkConnections(vararg argument: suspend VpnSiteLinkConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnSiteLinkConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnLinkConnections = mapped
    }

    /**
     * @param argument List of all vpn site link connections to the gateway.
     */
    @JvmName("homoaxiiiuwvhpeo")
    public suspend fun vpnLinkConnections(argument: suspend VpnSiteLinkConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnSiteLinkConnectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnLinkConnections = mapped
    }

    /**
     * @param values List of all vpn site link connections to the gateway.
     */
    @JvmName("ycxnrpikwkfenwlp")
    public suspend fun vpnLinkConnections(vararg values: VpnSiteLinkConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnLinkConnections = mapped
    }

    internal fun build(): VpnConnectionArgs = VpnConnectionArgs(
        connectionBandwidth = connectionBandwidth,
        dpdTimeoutSeconds = dpdTimeoutSeconds,
        enableBgp = enableBgp,
        enableInternetSecurity = enableInternetSecurity,
        enableRateLimiting = enableRateLimiting,
        id = id,
        ipsecPolicies = ipsecPolicies,
        name = name,
        remoteVpnSite = remoteVpnSite,
        routingConfiguration = routingConfiguration,
        routingWeight = routingWeight,
        sharedKey = sharedKey,
        trafficSelectorPolicies = trafficSelectorPolicies,
        useLocalAzureIpAddress = useLocalAzureIpAddress,
        usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors,
        vpnConnectionProtocolType = vpnConnectionProtocolType,
        vpnLinkConnections = vpnLinkConnections,
    )
}
