@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnLinkProviderPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * List of properties of a link provider.
 * @property linkProviderName Name of the link provider.
 * @property linkSpeedInMbps Link speed.
 */
public data class VpnLinkProviderPropertiesArgs(
    public val linkProviderName: Output<String>? = null,
    public val linkSpeedInMbps: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnLinkProviderPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnLinkProviderPropertiesArgs =
        com.pulumi.azurenative.network.inputs.VpnLinkProviderPropertiesArgs.builder()
            .linkProviderName(linkProviderName?.applyValue({ args0 -> args0 }))
            .linkSpeedInMbps(linkSpeedInMbps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnLinkProviderPropertiesArgs].
 */
@PulumiTagMarker
public class VpnLinkProviderPropertiesArgsBuilder internal constructor() {
    private var linkProviderName: Output<String>? = null

    private var linkSpeedInMbps: Output<Int>? = null

    /**
     * @param value Name of the link provider.
     */
    @JvmName("pshpuqyinciedlxk")
    public suspend fun linkProviderName(`value`: Output<String>) {
        this.linkProviderName = value
    }

    /**
     * @param value Link speed.
     */
    @JvmName("evkajuffcduvjqgk")
    public suspend fun linkSpeedInMbps(`value`: Output<Int>) {
        this.linkSpeedInMbps = value
    }

    /**
     * @param value Name of the link provider.
     */
    @JvmName("bqnmqncgpruewagh")
    public suspend fun linkProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkProviderName = mapped
    }

    /**
     * @param value Link speed.
     */
    @JvmName("pgncqqwvviosiuhr")
    public suspend fun linkSpeedInMbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkSpeedInMbps = mapped
    }

    internal fun build(): VpnLinkProviderPropertiesArgs = VpnLinkProviderPropertiesArgs(
        linkProviderName = linkProviderName,
        linkSpeedInMbps = linkSpeedInMbps,
    )
}
