@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnSiteLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * VpnSiteLink Resource.
 * @property bgpProperties The set of bgp properties.
 * @property fqdn FQDN of vpn-site-link.
 * @property id Resource ID.
 * @property ipAddress The ip-address for the vpn-site-link.
 * @property linkProperties The link provider properties.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 */
public data class VpnSiteLinkArgs(
    public val bgpProperties: Output<VpnLinkBgpSettingsArgs>? = null,
    public val fqdn: Output<String>? = null,
    public val id: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val linkProperties: Output<VpnLinkProviderPropertiesArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnSiteLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnSiteLinkArgs =
        com.pulumi.azurenative.network.inputs.VpnSiteLinkArgs.builder()
            .bgpProperties(bgpProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .linkProperties(linkProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnSiteLinkArgs].
 */
@PulumiTagMarker
public class VpnSiteLinkArgsBuilder internal constructor() {
    private var bgpProperties: Output<VpnLinkBgpSettingsArgs>? = null

    private var fqdn: Output<String>? = null

    private var id: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var linkProperties: Output<VpnLinkProviderPropertiesArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The set of bgp properties.
     */
    @JvmName("mqqbhjvtyevqmxhr")
    public suspend fun bgpProperties(`value`: Output<VpnLinkBgpSettingsArgs>) {
        this.bgpProperties = value
    }

    /**
     * @param value FQDN of vpn-site-link.
     */
    @JvmName("xochsdjqpwjumasd")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("skfjcstbytdwuufe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ip-address for the vpn-site-link.
     */
    @JvmName("qiuijcdwgcunjylh")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The link provider properties.
     */
    @JvmName("inaqwbpmatsaruuw")
    public suspend fun linkProperties(`value`: Output<VpnLinkProviderPropertiesArgs>) {
        this.linkProperties = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("pckmdofcdbpkprsc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The set of bgp properties.
     */
    @JvmName("syxwhqitrejsdknc")
    public suspend fun bgpProperties(`value`: VpnLinkBgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpProperties = mapped
    }

    /**
     * @param argument The set of bgp properties.
     */
    @JvmName("cjbtnicsnpdexgjv")
    public suspend fun bgpProperties(argument: suspend VpnLinkBgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = VpnLinkBgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpProperties = mapped
    }

    /**
     * @param value FQDN of vpn-site-link.
     */
    @JvmName("feektrvobvwhtawl")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tthvrfuspmmrauct")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ip-address for the vpn-site-link.
     */
    @JvmName("lpvujvwjybxyusku")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The link provider properties.
     */
    @JvmName("siiyoicopynkryky")
    public suspend fun linkProperties(`value`: VpnLinkProviderPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkProperties = mapped
    }

    /**
     * @param argument The link provider properties.
     */
    @JvmName("ixwfllfbpcgqgruq")
    public suspend fun linkProperties(argument: suspend VpnLinkProviderPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VpnLinkProviderPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkProperties = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("uiqkbroeswkmjsyf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VpnSiteLinkArgs = VpnSiteLinkArgs(
        bgpProperties = bgpProperties,
        fqdn = fqdn,
        id = id,
        ipAddress = ipAddress,
        linkProperties = linkProperties,
        name = name,
    )
}
