@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnSiteLinkConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionProtocol
import com.pulumi.azurenative.network.kotlin.enums.VpnLinkConnectionMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnSiteLinkConnection Resource.
 * @property connectionBandwidth Expected bandwidth in MBPS.
 * @property egressNatRules List of egress NatRules.
 * @property enableBgp EnableBgp flag.
 * @property enableRateLimiting EnableBgp flag.
 * @property id Resource ID.
 * @property ingressNatRules List of ingress NatRules.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routingWeight Routing weight for vpn connection.
 * @property sharedKey SharedKey for the vpn connection.
 * @property useLocalAzureIpAddress Use local azure ip to initiate connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property vpnConnectionProtocolType Connection protocol used for this connection.
 * @property vpnGatewayCustomBgpAddresses vpnGatewayCustomBgpAddresses used by this connection.
 * @property vpnLinkConnectionMode Vpn link connection mode.
 * @property vpnSiteLink Id of the connected vpn site link.
 */
public data class VpnSiteLinkConnectionArgs(
    public val connectionBandwidth: Output<Int>? = null,
    public val egressNatRules: Output<List<SubResourceArgs>>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enableRateLimiting: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val ingressNatRules: Output<List<SubResourceArgs>>? = null,
    public val ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val name: Output<String>? = null,
    public val routingWeight: Output<Int>? = null,
    public val sharedKey: Output<String>? = null,
    public val useLocalAzureIpAddress: Output<Boolean>? = null,
    public val usePolicyBasedTrafficSelectors: Output<Boolean>? = null,
    public val vpnConnectionProtocolType: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? = null,
    public val vpnGatewayCustomBgpAddresses: Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>? = null,
    public val vpnLinkConnectionMode: Output<Either<String, VpnLinkConnectionMode>>? = null,
    public val vpnSiteLink: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnSiteLinkConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnSiteLinkConnectionArgs =
        com.pulumi.azurenative.network.inputs.VpnSiteLinkConnectionArgs.builder()
            .connectionBandwidth(connectionBandwidth?.applyValue({ args0 -> args0 }))
            .egressNatRules(
                egressNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enableRateLimiting(enableRateLimiting?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ingressNatRules(
                ingressNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipsecPolicies(
                ipsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .useLocalAzureIpAddress(useLocalAzureIpAddress?.applyValue({ args0 -> args0 }))
            .usePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors?.applyValue({ args0 -> args0 }))
            .vpnConnectionProtocolType(
                vpnConnectionProtocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnGatewayCustomBgpAddresses(
                vpnGatewayCustomBgpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnLinkConnectionMode(
                vpnLinkConnectionMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnSiteLink(vpnSiteLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VpnSiteLinkConnectionArgs].
 */
@PulumiTagMarker
public class VpnSiteLinkConnectionArgsBuilder internal constructor() {
    private var connectionBandwidth: Output<Int>? = null

    private var egressNatRules: Output<List<SubResourceArgs>>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enableRateLimiting: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var ingressNatRules: Output<List<SubResourceArgs>>? = null

    private var ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var name: Output<String>? = null

    private var routingWeight: Output<Int>? = null

    private var sharedKey: Output<String>? = null

    private var useLocalAzureIpAddress: Output<Boolean>? = null

    private var usePolicyBasedTrafficSelectors: Output<Boolean>? = null

    private var vpnConnectionProtocolType:
        Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? = null

    private var vpnGatewayCustomBgpAddresses:
        Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>? = null

    private var vpnLinkConnectionMode: Output<Either<String, VpnLinkConnectionMode>>? = null

    private var vpnSiteLink: Output<SubResourceArgs>? = null

    /**
     * @param value Expected bandwidth in MBPS.
     */
    @JvmName("shllrvupgmvfdhrw")
    public suspend fun connectionBandwidth(`value`: Output<Int>) {
        this.connectionBandwidth = value
    }

    /**
     * @param value List of egress NatRules.
     */
    @JvmName("uqepxulrhqhvxuwr")
    public suspend fun egressNatRules(`value`: Output<List<SubResourceArgs>>) {
        this.egressNatRules = value
    }

    @JvmName("hnskqcvaqpvwoejc")
    public suspend fun egressNatRules(vararg values: Output<SubResourceArgs>) {
        this.egressNatRules = Output.all(values.asList())
    }

    /**
     * @param values List of egress NatRules.
     */
    @JvmName("hmkqqbsdaepsmjho")
    public suspend fun egressNatRules(values: List<Output<SubResourceArgs>>) {
        this.egressNatRules = Output.all(values)
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("hbvkmgvgskdpmaby")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("pxcwlussqyfijhcn")
    public suspend fun enableRateLimiting(`value`: Output<Boolean>) {
        this.enableRateLimiting = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mduscemxvgljjcxm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of ingress NatRules.
     */
    @JvmName("guwricxtppcbkvem")
    public suspend fun ingressNatRules(`value`: Output<List<SubResourceArgs>>) {
        this.ingressNatRules = value
    }

    @JvmName("jklyacojkeiouojn")
    public suspend fun ingressNatRules(vararg values: Output<SubResourceArgs>) {
        this.ingressNatRules = Output.all(values.asList())
    }

    /**
     * @param values List of ingress NatRules.
     */
    @JvmName("odkvuonwcjeldpev")
    public suspend fun ingressNatRules(values: List<Output<SubResourceArgs>>) {
        this.ingressNatRules = Output.all(values)
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("wvleevrbouiwgrth")
    public suspend fun ipsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.ipsecPolicies = value
    }

    @JvmName("huxjjvujwaprjbaw")
    public suspend fun ipsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.ipsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("vjkxycndwbrrwrcc")
    public suspend fun ipsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.ipsecPolicies = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("bomovgbpdssnhwru")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Routing weight for vpn connection.
     */
    @JvmName("aduvxbemgrjyckbl")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value SharedKey for the vpn connection.
     */
    @JvmName("rphlkmfibjxbeeob")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value Use local azure ip to initiate connection.
     */
    @JvmName("tjldrjwwrggmwald")
    public suspend fun useLocalAzureIpAddress(`value`: Output<Boolean>) {
        this.useLocalAzureIpAddress = value
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("xikqewauhhkrshdy")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Output<Boolean>) {
        this.usePolicyBasedTrafficSelectors = value
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("ocwtyhblqhvuhptu")
    public suspend fun vpnConnectionProtocolType(`value`: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>) {
        this.vpnConnectionProtocolType = value
    }

    /**
     * @param value vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("jbmxeyxhtbtbppvh")
    public suspend fun vpnGatewayCustomBgpAddresses(`value`: Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>) {
        this.vpnGatewayCustomBgpAddresses = value
    }

    @JvmName("tfmebqivjqkdlghj")
    public suspend fun vpnGatewayCustomBgpAddresses(vararg values: Output<GatewayCustomBgpIpAddressIpConfigurationArgs>) {
        this.vpnGatewayCustomBgpAddresses = Output.all(values.asList())
    }

    /**
     * @param values vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("akrgsrwdwbnicdsj")
    public suspend fun vpnGatewayCustomBgpAddresses(values: List<Output<GatewayCustomBgpIpAddressIpConfigurationArgs>>) {
        this.vpnGatewayCustomBgpAddresses = Output.all(values)
    }

    /**
     * @param value Vpn link connection mode.
     */
    @JvmName("ayoaympskgyncuhp")
    public suspend fun vpnLinkConnectionMode(`value`: Output<Either<String, VpnLinkConnectionMode>>) {
        this.vpnLinkConnectionMode = value
    }

    /**
     * @param value Id of the connected vpn site link.
     */
    @JvmName("agrcrvrykevcihgk")
    public suspend fun vpnSiteLink(`value`: Output<SubResourceArgs>) {
        this.vpnSiteLink = value
    }

    /**
     * @param value Expected bandwidth in MBPS.
     */
    @JvmName("ywfoksydhvsxumav")
    public suspend fun connectionBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionBandwidth = mapped
    }

    /**
     * @param value List of egress NatRules.
     */
    @JvmName("kmobjeruyonhnxoq")
    public suspend fun egressNatRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("skvaaldxvuboclan")
    public suspend fun egressNatRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("fprbcpkuklxwldsn")
    public suspend fun egressNatRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("bawjvmqweyrigyjl")
    public suspend fun egressNatRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param values List of egress NatRules.
     */
    @JvmName("phwoulbtudbyumac")
    public suspend fun egressNatRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressNatRules = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("gjkwrubqrallrjea")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("scjvtmyqcpxtmtlo")
    public suspend fun enableRateLimiting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRateLimiting = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gonlwkwwiwdjkgsi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of ingress NatRules.
     */
    @JvmName("dwhikuwcjqfcjkab")
    public suspend fun ingressNatRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("ojigyulbbsflglmp")
    public suspend fun ingressNatRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("abwnjsmwqxhooeav")
    public suspend fun ingressNatRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("ddtgamlwxrooydpo")
    public suspend fun ingressNatRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param values List of ingress NatRules.
     */
    @JvmName("ojuprjknelrytvfa")
    public suspend fun ingressNatRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingressNatRules = mapped
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("yohoqxgrsfxcjtau")
    public suspend fun ipsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("nepaqcbbjuagebmg")
    public suspend fun ipsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("qooybgfglvqohmjx")
    public suspend fun ipsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("ycndifftxxdrbuvj")
    public suspend fun ipsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("ikvfddjixypcklhn")
    public suspend fun ipsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qogynwrntselfwqc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Routing weight for vpn connection.
     */
    @JvmName("tilpqfndkvlbibtb")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    /**
     * @param value SharedKey for the vpn connection.
     */
    @JvmName("oeqnkkfnykhcrtph")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value Use local azure ip to initiate connection.
     */
    @JvmName("ncuvutllucbypryi")
    public suspend fun useLocalAzureIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLocalAzureIpAddress = mapped
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("ntditghriccvtjkw")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePolicyBasedTrafficSelectors = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("vfjxabhibqaxhkov")
    public suspend fun vpnConnectionProtocolType(`value`: Either<String, VirtualNetworkGatewayConnectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("yfbntgitsmswpqrj")
    public fun vpnConnectionProtocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("qvrpeaqtcfyvadjg")
    public fun vpnConnectionProtocolType(`value`: VirtualNetworkGatewayConnectionProtocol) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnConnectionProtocolType = mapped
    }

    /**
     * @param value vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("baotafefsksjobiw")
    public suspend fun vpnGatewayCustomBgpAddresses(`value`: List<GatewayCustomBgpIpAddressIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayCustomBgpAddresses = mapped
    }

    /**
     * @param argument vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("oyvtfhkbaxptqjeh")
    public suspend fun vpnGatewayCustomBgpAddresses(argument: List<suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnGatewayCustomBgpAddresses = mapped
    }

    /**
     * @param argument vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("ybcgrmdwiwgkfyam")
    public suspend fun vpnGatewayCustomBgpAddresses(vararg argument: suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnGatewayCustomBgpAddresses = mapped
    }

    /**
     * @param argument vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("hmhltqlicnfjwwjc")
    public suspend fun vpnGatewayCustomBgpAddresses(argument: suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnGatewayCustomBgpAddresses = mapped
    }

    /**
     * @param values vpnGatewayCustomBgpAddresses used by this connection.
     */
    @JvmName("xesaeuartbksrows")
    public suspend fun vpnGatewayCustomBgpAddresses(vararg values: GatewayCustomBgpIpAddressIpConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnGatewayCustomBgpAddresses = mapped
    }

    /**
     * @param value Vpn link connection mode.
     */
    @JvmName("xgetynftpgfkbkmj")
    public suspend fun vpnLinkConnectionMode(`value`: Either<String, VpnLinkConnectionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnLinkConnectionMode = mapped
    }

    /**
     * @param value Vpn link connection mode.
     */
    @JvmName("ckivnvbfmvtfdyau")
    public fun vpnLinkConnectionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnLinkConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnLinkConnectionMode = mapped
    }

    /**
     * @param value Vpn link connection mode.
     */
    @JvmName("mifkqtqrjlopolub")
    public fun vpnLinkConnectionMode(`value`: VpnLinkConnectionMode) {
        val toBeMapped = Either.ofRight<String, VpnLinkConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnLinkConnectionMode = mapped
    }

    /**
     * @param value Id of the connected vpn site link.
     */
    @JvmName("tnhnutgvdswrwuud")
    public suspend fun vpnSiteLink(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnSiteLink = mapped
    }

    /**
     * @param argument Id of the connected vpn site link.
     */
    @JvmName("mcnisubljkujvuvi")
    public suspend fun vpnSiteLink(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnSiteLink = mapped
    }

    internal fun build(): VpnSiteLinkConnectionArgs = VpnSiteLinkConnectionArgs(
        connectionBandwidth = connectionBandwidth,
        egressNatRules = egressNatRules,
        enableBgp = enableBgp,
        enableRateLimiting = enableRateLimiting,
        id = id,
        ingressNatRules = ingressNatRules,
        ipsecPolicies = ipsecPolicies,
        name = name,
        routingWeight = routingWeight,
        sharedKey = sharedKey,
        useLocalAzureIpAddress = useLocalAzureIpAddress,
        usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors,
        vpnConnectionProtocolType = vpnConnectionProtocolType,
        vpnGatewayCustomBgpAddresses = vpnGatewayCustomBgpAddresses,
        vpnLinkConnectionMode = vpnLinkConnectionMode,
        vpnSiteLink = vpnSiteLink,
    )
}
