@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.WebApplicationFirewallScrubbingRulesArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ScrubbingRuleEntryMatchOperator
import com.pulumi.azurenative.network.kotlin.enums.ScrubbingRuleEntryMatchVariable
import com.pulumi.azurenative.network.kotlin.enums.ScrubbingRuleEntryState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allow certain variables to be scrubbed on WAF logs
 * @property matchVariable The variable to be scrubbed from the logs.
 * @property selector When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
 * @property selectorMatchOperator When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to.
 * @property state Defines the state of log scrubbing rule. Default value is Enabled.
 */
public data class WebApplicationFirewallScrubbingRulesArgs(
    public val matchVariable: Output<Either<String, ScrubbingRuleEntryMatchVariable>>,
    public val selector: Output<String>? = null,
    public val selectorMatchOperator: Output<Either<String, ScrubbingRuleEntryMatchOperator>>,
    public val state: Output<Either<String, ScrubbingRuleEntryState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.WebApplicationFirewallScrubbingRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.WebApplicationFirewallScrubbingRulesArgs =
        com.pulumi.azurenative.network.inputs.WebApplicationFirewallScrubbingRulesArgs.builder()
            .matchVariable(
                matchVariable.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .selectorMatchOperator(
                selectorMatchOperator.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebApplicationFirewallScrubbingRulesArgs].
 */
@PulumiTagMarker
public class WebApplicationFirewallScrubbingRulesArgsBuilder internal constructor() {
    private var matchVariable: Output<Either<String, ScrubbingRuleEntryMatchVariable>>? = null

    private var selector: Output<String>? = null

    private var selectorMatchOperator: Output<Either<String, ScrubbingRuleEntryMatchOperator>>? = null

    private var state: Output<Either<String, ScrubbingRuleEntryState>>? = null

    /**
     * @param value The variable to be scrubbed from the logs.
     */
    @JvmName("ftflogbwamtwvqyb")
    public suspend fun matchVariable(`value`: Output<Either<String, ScrubbingRuleEntryMatchVariable>>) {
        this.matchVariable = value
    }

    /**
     * @param value When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
     */
    @JvmName("okihnnhuijlihkdw")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to.
     */
    @JvmName("gqavisskpuxcpddc")
    public suspend fun selectorMatchOperator(`value`: Output<Either<String, ScrubbingRuleEntryMatchOperator>>) {
        this.selectorMatchOperator = value
    }

    /**
     * @param value Defines the state of log scrubbing rule. Default value is Enabled.
     */
    @JvmName("wjlvmplseqeseobn")
    public suspend fun state(`value`: Output<Either<String, ScrubbingRuleEntryState>>) {
        this.state = value
    }

    /**
     * @param value The variable to be scrubbed from the logs.
     */
    @JvmName("nrmfnkohcjmwnacc")
    public suspend fun matchVariable(`value`: Either<String, ScrubbingRuleEntryMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value The variable to be scrubbed from the logs.
     */
    @JvmName("mlunlpqswfbllbns")
    public fun matchVariable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScrubbingRuleEntryMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value The variable to be scrubbed from the logs.
     */
    @JvmName("hkgvgeatsffpdfaj")
    public fun matchVariable(`value`: ScrubbingRuleEntryMatchVariable) {
        val toBeMapped = Either.ofRight<String, ScrubbingRuleEntryMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
     */
    @JvmName("vtlxkdkydtvqcjcp")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to.
     */
    @JvmName("khjxqcfmrfvoxsit")
    public suspend fun selectorMatchOperator(`value`: Either<String, ScrubbingRuleEntryMatchOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to.
     */
    @JvmName("xriiykmonhxrjeuf")
    public fun selectorMatchOperator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScrubbingRuleEntryMatchOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to.
     */
    @JvmName("dfobngrxvgptfgod")
    public fun selectorMatchOperator(`value`: ScrubbingRuleEntryMatchOperator) {
        val toBeMapped = Either.ofRight<String, ScrubbingRuleEntryMatchOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value Defines the state of log scrubbing rule. Default value is Enabled.
     */
    @JvmName("rcfthiwegritosqb")
    public suspend fun state(`value`: Either<String, ScrubbingRuleEntryState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Defines the state of log scrubbing rule. Default value is Enabled.
     */
    @JvmName("shbcdgvryxorufaf")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScrubbingRuleEntryState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Defines the state of log scrubbing rule. Default value is Enabled.
     */
    @JvmName("fskncignqblsnuci")
    public fun state(`value`: ScrubbingRuleEntryState) {
        val toBeMapped = Either.ofRight<String, ScrubbingRuleEntryState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): WebApplicationFirewallScrubbingRulesArgs =
        WebApplicationFirewallScrubbingRulesArgs(
            matchVariable = matchVariable ?: throw PulumiNullFieldException("matchVariable"),
            selector = selector,
            selectorMatchOperator = selectorMatchOperator ?: throw
                PulumiNullFieldException("selectorMatchOperator"),
            state = state,
        )
}
