@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An AAAA record.
 * @property ipv6Address The IPv6 address of this AAAA record.
 */
public data class AaaaRecordResponse(
    public val ipv6Address: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AaaaRecordResponse): AaaaRecordResponse = AaaaRecordResponse(
            ipv6Address = javaType.ipv6Address().map({ args0 -> args0 }).orElse(null),
        )
    }
}
