@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network security user rule.
 * @property commitTime Deployment time string.
 * @property configurationDescription A description of the security user configuration.
 * @property configurationDisplayName A display name of the security user configuration.
 * @property description A description for this rule.
 * @property destinationPortRanges The destination port ranges.
 * @property destinations The destination address prefixes. CIDR or destination IP ranges.
 * @property direction Indicates if the traffic matched against the rule in inbound or outbound.
 * @property displayName A friendly name for the rule.
 * @property id Resource ID.
 * @property kind Whether the rule is custom or default.
 * Expected value is 'Custom'.
 * @property protocol Network protocol this rule applies to.
 * @property provisioningState The provisioning state of the security configuration user rule resource.
 * @property region Deployment region.
 * @property ruleCollectionAppliesToGroups Groups for rule collection
 * @property ruleCollectionDescription A description of the rule collection.
 * @property ruleCollectionDisplayName A display name of the rule collection.
 * @property ruleGroups Effective configuration groups.
 * @property sourcePortRanges The source port ranges.
 * @property sources The CIDR or source IP ranges.
 */
public data class ActiveSecurityUserRuleResponse(
    public val commitTime: String? = null,
    public val configurationDescription: String? = null,
    public val configurationDisplayName: String? = null,
    public val description: String? = null,
    public val destinationPortRanges: List<String>? = null,
    public val destinations: List<AddressPrefixItemResponse>? = null,
    public val direction: String,
    public val displayName: String? = null,
    public val id: String? = null,
    public val kind: String,
    public val protocol: String,
    public val provisioningState: String,
    public val region: String? = null,
    public val ruleCollectionAppliesToGroups: List<NetworkManagerSecurityGroupItemResponse>? = null,
    public val ruleCollectionDescription: String? = null,
    public val ruleCollectionDisplayName: String? = null,
    public val ruleGroups: List<ConfigurationGroupResponse>? = null,
    public val sourcePortRanges: List<String>? = null,
    public val sources: List<AddressPrefixItemResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ActiveSecurityUserRuleResponse): ActiveSecurityUserRuleResponse = ActiveSecurityUserRuleResponse(
            commitTime = javaType.commitTime().map({ args0 -> args0 }).orElse(null),
            configurationDescription = javaType.configurationDescription().map({ args0 -> args0 }).orElse(null),
            configurationDisplayName = javaType.configurationDisplayName().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 -> args0 }),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin(args0)
                })
            }),
            direction = javaType.direction(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            ruleCollectionAppliesToGroups = javaType.ruleCollectionAppliesToGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerSecurityGroupItemResponse.Companion.toKotlin(args0)
                })
            }),
            ruleCollectionDescription = javaType.ruleCollectionDescription().map({ args0 ->
                args0
            }).orElse(null),
            ruleCollectionDisplayName = javaType.ruleCollectionDisplayName().map({ args0 ->
                args0
            }).orElse(null),
            ruleGroups = javaType.ruleGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConfigurationGroupResponse.Companion.toKotlin(args0)
                })
            }),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 -> args0 }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
