@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Backend Address Pool of an application gateway.
 * @property backendAddresses Backend addresses.
 * @property backendIPConfigurations Collection of references to IPs defined in network interfaces.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the backend address pool that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the backend address pool resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayBackendAddressPoolResponse(
    public val backendAddresses: List<ApplicationGatewayBackendAddressResponse>? = null,
    public val backendIPConfigurations: List<NetworkInterfaceIPConfigurationResponse>,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayBackendAddressPoolResponse): ApplicationGatewayBackendAddressPoolResponse = ApplicationGatewayBackendAddressPoolResponse(
            backendAddresses = javaType.backendAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendAddressResponse.Companion.toKotlin(args0)
                })
            }),
            backendIPConfigurations = javaType.backendIPConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
